# First and foremost consider this:
- This is a DEVELOPER oriented channel dedicated to report bugs and suggest features about the libretro core, please do not ask for help. If you need help, go to https://forums.libretro.com/;
- The upstream bug tracker is a forum thread, located at https://forum.fobby.net/index.php?t=msg&th=1114;
    - Note: As of October 2018, Microsoft email providers (think email addresses ending with hotmail/live/outlook) are rejecting email from the forum. If you want to register an account in the upstream project's forum, consider using another mail provider.
- For game-related bugs:
    1) First, check if it's already reported on the upstream bug tracker;
    2) If it's not reported there, try to reproduce the bug with mednafen;
    3) If it's reproducible with mednafen, report it on the upstream bugtracker;
    4) If it's not reproducible with mednafen, ONLY THEN should you report it here.
    5) DO NOT report Beetle-specific bugs on the upstream tracker.

## Description

[Description of the bug]

### Expected behavior

[What you expected to happen]
[Photos/videos of original hardware behavior and/or mednafen behavior]

### Actual behavior

[What is actually happening]
[Photos/videos of the core's behavior]

### Steps to reproduce the bug

1. [First step]
2. [Second step]
3. [and so on...]

### Bisect results

[Try to bisect and tell us when this started happening]

### Version/Commit

[If you're using RetroArch, this information is on the bottom left after loading the core. You can do this via Main Menu -> Load Core]

- Beetle PSX: [version/commit] or Beetle PSX HW: [version/commit]

Please specify whether you are using Beetle PSX or Beetle PSX HW.

### Core options

[List all the core options you have changed]

Please also specify, if reporting a graphical glitch for Beetle PSX HW, your "Renderer" core option setting and your frontend selected video driver.

### Environment information

- Frontend: [Frontend name and version]
- OS: [Operating System name and version]
- Compiler: [In case you are running local builds]
- GPU: [Graphics card and driver version, if you're using the HW version]
