/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.Length;

public class NonNegativeLength
extends Length {
    private static final Pattern nonNegativeLengthPattern = Pattern.compile("^?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)((cm)|(mm)|(in)|(pt)|(pc)|(px))$");

    public NonNegativeLength(String length) throws NumberFormatException {
        super(length);
        if (!NonNegativeLength.isValid(length)) {
            throw new NumberFormatException("parameter is invalid for datatype NonNegativeLength");
        }
    }

    public static NonNegativeLength valueOf(String stringValue) throws NumberFormatException {
        return new NonNegativeLength(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && nonNegativeLengthPattern.matcher(stringValue).matches();
    }
}

