/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.bitmap.DIBReader;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdDibStretchBlt
extends MfCmd {
    private static final int POS_DIB = 10;
    private static final int POS_OPERATION = 0;
    private static final int POS_SRC_HEIGHT = 2;
    private static final int POS_SRC_WIDTH = 3;
    private static final int POS_SRC_Y = 4;
    private static final int POS_SRC_X = 5;
    private static final int POS_DST_HEIGHT = 6;
    private static final int POS_DST_WIDTH = 7;
    private static final int POS_DST_Y = 8;
    private static final int POS_DST_X = 9;
    private BufferedImage image;
    private int rop;
    private int srcX;
    private int srcY;
    private int srcW;
    private int srcH;
    private int destX;
    private int destY;
    private int destW;
    private int destH;
    private int scaled_destX;
    private int scaled_destY;
    private int scaled_destW;
    private int scaled_destH;

    public void replay(WmfFile file) {
        file.getGraphics2D().drawImage(this.image, this.srcX, this.srcY, this.srcW, this.srcH, this.scaled_destX, this.scaled_destY, this.scaled_destW, this.scaled_destH, null);
    }

    public MfCmd getInstance() {
        return new MfCmdDibStretchBlt();
    }

    public int getFunction() {
        return 2881;
    }

    public int getROP() {
        return this.rop;
    }

    public void setROP(int rop) {
        this.rop = rop;
    }

    public void setRecord(MfRecord record) {
        int rop = record.getLongParam(0);
        int ySrc = record.getParam(4);
        int xSrc = record.getParam(5);
        int srcH = record.getParam(2);
        int srcW = record.getParam(3);
        int destH = record.getParam(6);
        int destW = record.getParam(7);
        int yDest = record.getParam(8);
        int xDest = record.getParam(9);
        try {
            DIBReader reader = new DIBReader();
            this.setImage(reader.setRecord(record, 10));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.setROP(rop);
        this.setSrcRect(xSrc, ySrc, srcH, srcW);
        this.setDestRect(xDest, yDest, destH, destW);
    }

    public MfRecord getRecord() throws RecordCreationException {
        throw new RecordCreationException("StretchBlt is not supported");
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[STRETCH_BLT] rop=");
        b.append(this.getROP());
        b.append(" srcRect=");
        b.append(this.getSrcRect());
        b.append(" destRect=");
        b.append(this.getDestRect());
        return b.toString();
    }

    public void setSrcRect(int x, int y, int w, int h) {
        this.srcX = x;
        this.srcY = y;
        this.srcW = w;
        this.srcH = h;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDestRect(int x, int y, int w, int h) {
        this.destX = x;
        this.destY = y;
        this.destW = w;
        this.destH = h;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Rectangle getSrcRect() {
        return new Rectangle(this.srcX, this.srcY, this.srcW, this.srcH);
    }

    public Rectangle getDestRect() {
        return new Rectangle(this.destX, this.destY, this.destW, this.destH);
    }

    public Rectangle getScaledDestRect() {
        return new Rectangle(this.scaled_destX, this.scaled_destY, this.scaled_destW, this.scaled_destH);
    }

    protected void scaleXChanged() {
        this.scaled_destX = this.getScaledX(this.destX);
        this.scaled_destW = this.getScaledX(this.destW);
    }

    protected void scaleYChanged() {
        this.scaled_destY = this.getScaledY(this.destY);
        this.scaled_destH = this.getScaledY(this.destH);
    }
}

