/* Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@cryptsoft.com).
 * The implementation was written so as to conform with Netscapes SSL.
 *
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@cryptsoft.com).
 *
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@cryptsoft.com)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@cryptsoft.com)"
 *
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com). */

#ifndef OPENSSL_HEADER_CPU_H
#define OPENSSL_HEADER_CPU_H

#include <openssl/base.h>

#if defined(__cplusplus)
extern "C" {
#endif


/* Runtime CPU feature support */


#if defined(OPENSSL_X86) || defined(OPENSSL_X86_64)
/* OPENSSL_ia32cap_P contains the Intel CPUID bits when running on an x86 or
 * x86-64 system.
 *
 *   Index 0:
 *     EDX for CPUID where EAX = 1
 *     Bit 20 is always zero
 *     Bit 28 is adjusted to reflect whether the data cache is shared between
 *       multiple logical cores
 *     Bit 30 is used to indicate an Intel CPU
 *   Index 1:
 *     ECX for CPUID where EAX = 1
 *     Bit 11 is used to indicate AMD XOP support, not SDBG
 *   Index 2:
 *     EBX for CPUID where EAX = 7
 *   Index 3 is set to zero.
 *
 * Note: the CPUID bits are pre-adjusted for the OSXSAVE bit and the YMM and XMM
 * bits in XCR0, so it is not necessary to check those. */
extern uint32_t OPENSSL_ia32cap_P[4];
#endif

#if defined(OPENSSL_ARM) || defined(OPENSSL_AARCH64)

#if defined(OPENSSL_APPLE)
/* iOS builds use the static ARM configuration. */
#define OPENSSL_STATIC_ARMCAP
#endif

#if !defined(OPENSSL_STATIC_ARMCAP)

/* CRYPTO_is_NEON_capable returns true if the current CPU has a NEON unit. Note
 * that |OPENSSL_armcap_P| also exists and contains the same information in a
 * form that's easier for assembly to use. */
OPENSSL_EXPORT char CRYPTO_is_NEON_capable(void);

/* CRYPTO_set_NEON_capable sets the return value of |CRYPTO_is_NEON_capable|.
 * By default, unless the code was compiled with |-mfpu=neon|, NEON is assumed
 * not to be present. It is not autodetected. Calling this with a zero
 * argument also causes |CRYPTO_is_NEON_functional| to return false. */
OPENSSL_EXPORT void CRYPTO_set_NEON_capable(char neon_capable);

/* CRYPTO_is_NEON_functional returns true if the current CPU has a /working/
 * NEON unit. Some phones have a NEON unit, but the Poly1305 NEON code causes
 * it to fail. See https://code.google.com/p/chromium/issues/detail?id=341598 */
OPENSSL_EXPORT char CRYPTO_is_NEON_functional(void);

/* CRYPTO_set_NEON_functional sets the "NEON functional" flag. For
 * |CRYPTO_is_NEON_functional| to return true, both this flag and the NEON flag
 * must be true. By default NEON is assumed to be functional if the code was
 * compiled with |-mfpu=neon| or if |CRYPTO_set_NEON_capable| has been called
 * with a non-zero argument. */
OPENSSL_EXPORT void CRYPTO_set_NEON_functional(char neon_functional);

/* CRYPTO_is_ARMv8_AES_capable returns true if the current CPU supports the
 * ARMv8 AES instruction. */
int CRYPTO_is_ARMv8_AES_capable(void);

/* CRYPTO_is_ARMv8_PMULL_capable returns true if the current CPU supports the
 * ARMv8 PMULL instruction. */
int CRYPTO_is_ARMv8_PMULL_capable(void);

#else

static inline int CRYPTO_is_NEON_capable(void) {
#if defined(OPENSSL_STATIC_ARMCAP_NEON) || defined(__ARM_NEON__)
  return 1;
#else
  return 0;
#endif
}

static inline int CRYPTO_is_NEON_functional(void) {
  return CRYPTO_is_NEON_capable();
}

static inline int CRYPTO_is_ARMv8_AES_capable(void) {
#if defined(OPENSSL_STATIC_ARMCAP_AES)
  return 1;
#else
  return 0;
#endif
}

static inline int CRYPTO_is_ARMv8_PMULL_capable(void) {
#if defined(OPENSSL_STATIC_ARMCAP_PMULL)
  return 1;
#else
  return 0;
#endif
}

#endif  /* OPENSSL_STATIC_ARMCAP */
#endif  /* OPENSSL_ARM */


#if defined(__cplusplus)
}  /* extern C */
#endif

#endif  /* OPENSSL_HEADER_CPU_H */
