/* $Id: stubs.c,v 1.6 2005/07/30 16:31:59 cegger Exp $
   ******************************************************************************

   LIBGCP: extension stubs

   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   ******************************************************************************
 */

#include "config.h"
#include <ggi/internal/gcp.h>
#include <ggi/internal/gcp_debug.h>


/* Color palette manipulation
 */

/* RGBA */
gcp_pixel gcpMapRGBAColor(ggi_visual_t vis, gcp_RGBAcolor *col)
{
	return LIBGGI_GCPEXT(vis)->MapRGBAColor(vis, col);
}	/* gcpMapRGBAColor */


int gcpUnmapRGBAPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_RGBAcolor *col)
{
	return LIBGGI_GCPEXT(vis)->UnmapRGBAPixel(vis, pixel, col);
}	/* gcpUnmapRGBAPixel */


int gcpPackRGBAColors(ggi_visual_t vis,void *buf,gcp_RGBAcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->PackRGBAColors(vis, buf, cols, len);
}	/* gcpPackRGBAColors */


int gcpUnpackRGBAPixels(ggi_visual_t vis,void *buf,gcp_RGBAcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->UnpackRGBAPixels(vis, buf, cols, len);
}	/* gcpUnpackRGBAPixels */


int gcpGetRGBAPalette(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->GetRGBAPalette(vis, s, len, cmap);
}	/* gcpRGBAPalette */


int gcpSetRGBAPalette(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->SetRGBAPalette(vis, s, len, cmap);
}	/* gcpSetRGBAPalette */




/* YUV */
gcp_pixel gcpMapYUVColor(ggi_visual_t vis, gcp_YUVcolor *col)
{
	return LIBGGI_GCPEXT(vis)->MapYUVColor(vis, col);
}	/* gcpMapYUVColor */


int gcpUnmapYUVPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_YUVcolor *col)
{
	return LIBGGI_GCPEXT(vis)->UnmapYUVPixel(vis, pixel, col);
}	/* gcpUnmapYUVPixel */



int gcpPackYUVColors(ggi_visual_t vis,void *buf,gcp_YUVcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->PackYUVColors(vis, buf, cols, len);
}	/* gcpPackYUVColors */


int gcpUnpackYUVPixels(ggi_visual_t vis,void *buf,gcp_YUVcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->UnpackYUVPixels(vis, buf, cols, len);
}	/* gcpUnpackYUVPixels */



int gcpGetYUVPalette(ggi_visual_t vis,int s,int len,gcp_YUVcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->GetYUVPalette(vis, s, len, cmap);
}	/* gcpGetYUVPalette */


int gcpSetYUVPalette(ggi_visual_t vis,int s,int len,gcp_YUVcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->SetYUVPalette(vis, s, len, cmap);
}	/* gcpSetYUVPalette */




/* CMYK */
gcp_pixel gcpMapCMYKColor(ggi_visual_t vis, gcp_CMYKcolor *col)
{
	return LIBGGI_GCPEXT(vis)->MapCMYKColor(vis, col);
}	/* gcpMapCMYKColor */


int gcpUnmapCMYKPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_CMYKcolor *col)
{
	return LIBGGI_GCPEXT(vis)->UnmapCMYKPixel(vis, pixel, col);
}	/* gcpUnmapCMYKPixel */



int gcpPackCMYKColors(ggi_visual_t vis,void *buf,gcp_CMYKcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->PackCMYKColors(vis, buf, cols, len);
}	/* gcpPackCMYKColors */


int gcpUnpackCMYKPixels(ggi_visual_t vis,void *buf,gcp_CMYKcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->UnpackCMYKPixels(vis, buf, cols, len);
}	/* gcpUnpackCMYKPixels */



int gcpGetCMYKPalette(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->GetCMYKPalette(vis, s, len, cmap);
}	/* gcpGetCMYKPalette */


int gcpSetCMYKPalette(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->SetCMYKPalette(vis, s, len, cmap);
}	/* gcpSetCMYKPalette */




/* HSV */
gcp_pixel gcpMapHSVColor(ggi_visual_t vis, gcp_HSVcolor *col)
{
	return LIBGGI_GCPEXT(vis)->MapHSVColor(vis, col);
}	/* gcpMapHSVColor */


int gcpUnmapHSVPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_HSVcolor *col)
{
	return LIBGGI_GCPEXT(vis)->UnmapHSVPixel(vis, pixel, col);
}	/* gcpUnmapHSVPixel */



int gcpPackHSVColors(ggi_visual_t vis,void *buf,gcp_HSVcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->PackHSVColors(vis, buf, cols, len);
}	/* gcpPackHSVColors */


int gcpUnpackHSVPixels(ggi_visual_t vis,void *buf,gcp_HSVcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->UnpackHSVPixels(vis, buf, cols, len);
}	/* gcpUnpackHSVPixels */



int gcpGetHSVPalette(ggi_visual_t vis,int s,int len,gcp_HSVcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->GetHSVPalette(vis, s, len, cmap);
}	/* gcpGetHSVPalette */


int gcpSetHSVPalette(ggi_visual_t vis,int s,int len,gcp_HSVcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->SetHSVPalette(vis, s, len, cmap);
}	/* gcpSetHSVPalette */



/* Kodak PhotoCD */
gcp_pixel gcpMapYCCColor(ggi_visual_t vis, gcp_YCCcolor *col)
{
	return LIBGGI_GCPEXT(vis)->MapYCCColor(vis, col);
}	/* gcpMapYCCColor */


int gcpUnmapYCCPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_YCCcolor *col)
{
	return LIBGGI_GCPEXT(vis)->UnmapYCCPixel(vis, pixel, col);
}	/* gcpUnmapYCCPixel */



int gcpPackYCCColors(ggi_visual_t vis,void *buf,gcp_YCCcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->PackYCCColors(vis, buf, cols, len);
}	/* gcpPackYCCColors */


int gcpUnpackYCCPixels(ggi_visual_t vis,void *buf,gcp_YCCcolor *cols,int len)
{
	return LIBGGI_GCPEXT(vis)->UnpackYCCPixels(vis, buf, cols, len);
}	/* gcpUnpackYCCPixels */



int gcpGetYCCPalette(ggi_visual_t vis,int s,int len,gcp_YCCcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->GetYCCPalette(vis, s, len, cmap);
}	/* gcpGetYCCPalette */


int gcpSetYCCPalette(ggi_visual_t vis,int s,int len,gcp_YCCcolor *cmap)
{
	return LIBGGI_GCPEXT(vis)->SetYCCPalette(vis, s, len, cmap);
}	/* gcpSetYCCPalette */






int gcpSetColorfulPalette(ggi_visual_t vis)
{
	return ggiSetColorfulPalette(vis);
}	/* gcpSetColorfulPalette */




/* Gamma map manipulation
 */

/* RGBA */
int gcpGetRGBAGamma(ggi_visual_t vis,ggi_float *r,ggi_float *g,ggi_float *b)
{
	return LIBGGI_GCPEXT(vis)->GetRGBAGamma(vis, r, g, b);
}	/* gcpGetRGBAGamma */


int gcpSetRGBAGamma(ggi_visual_t vis,ggi_float r,ggi_float g,ggi_float b)
{
	return LIBGGI_GCPEXT(vis)->SetRGBAGamma(vis, r, g, b);
}	/* gcpSetRGBAGamma */



int gcpGetRGBAGammaMap(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->GetRGBAGammaMap(vis, s, len, gammamap);
}	/* gcpGetRGBAGammaMap */


int gcpSetRGBAGammaMap(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->SetRGBAGammaMap(vis, s, len, gammamap);
}	/* gcpSetRGBAGammaMap */




/* YUV */
int gcpGetYUVGamma(ggi_visual_t vis,ggi_float *y,ggi_float *u,ggi_float *v)
{
	return LIBGGI_GCPEXT(vis)->GetYUVGamma(vis, y, u, v);
}	/* gcpGetYUVGamma */


int gcpSetYUVGamma(ggi_visual_t vis,ggi_float y,ggi_float u,ggi_float v)
{
	return LIBGGI_GCPEXT(vis)->SetYUVGamma(vis, y, u, v);
}	/* gcpSetYUVGamma */



int gcpGetYUVGammaMap(ggi_visual_t vis,int s,int len,gcp_YUVcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->GetYUVGammaMap(vis, s, len, gammamap);
}	/* gcpGetYUVGammaMap */


int gcpSetYUVGammaMap(ggi_visual_t vis,int s,int len,gcp_YUVcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->SetYUVGammaMap(vis, s, len, gammamap);
}	/* gcpSetYUVGammaMap */




/* CMYK */
int gcpGetCMYKGamma(ggi_visual_t vis,ggi_float *c,ggi_float *m,ggi_float *y,ggi_float *k)
{
	return LIBGGI_GCPEXT(vis)->GetCMYKGamma(vis, c, m, y, k);
}	/* gcpGetCMYKGamma */


int gcpSetCMYKGamma(ggi_visual_t vis,ggi_float c,ggi_float m,ggi_float y,ggi_float k)
{
	return LIBGGI_GCPEXT(vis)->SetCMYKGamma(vis, c, m, y, k);
}	/* gcpSetCMYKGamma */



int gcpGetCMYKGammaMap(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->GetCMYKGammaMap(vis, s, len, gammamap);
}	/* gcpGetCMYKGammaMap */


int gcpSetCMYKGammaMap(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->SetCMYKGammaMap(vis, s, len, gammamap);
}	/* gcpSetCMYKGammaMap */




/* HSV */
int gcpGetHSVGamma(ggi_visual_t vis,ggi_float *h,ggi_float *s,ggi_float *v)
{
	return LIBGGI_GCPEXT(vis)->GetHSVGamma(vis, h, s, v);
}	/* gcpGetHSVGamma */


int gcpSetHSVGamma(ggi_visual_t vis,ggi_float h,ggi_float s,ggi_float v)
{
	return LIBGGI_GCPEXT(vis)->SetHSVGamma(vis, h, s, v);
}	/* gcpSetHSVGamma */



int gcpGetHSVGammaMap(ggi_visual_t vis,int s,int len,gcp_HSVcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->GetHSVGammaMap(vis, s, len, gammamap);
}	/* gcpGetHSVGammaMap */


int gcpSetHSVGammaMap(ggi_visual_t vis,int s,int len,gcp_HSVcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->SetHSVGammaMap(vis, s, len, gammamap);
}	/* gcpSetHSVGammaMap */




/* Kodak PhotoCD */
int gcpGetYCCGamma(ggi_visual_t vis,ggi_float *h,ggi_float *s,ggi_float *v)
{
	return LIBGGI_GCPEXT(vis)->GetYCCGamma(vis, h, s, v);
}	/* gcpGetYCCGamma */


int gcpSetYCCGamma(ggi_visual_t vis,ggi_float h,ggi_float s,ggi_float v)
{
	return LIBGGI_GCPEXT(vis)->SetYCCGamma(vis, h, s, v);
}	/* gcpSetYCCGamma */



int gcpGetYCCGammaMap(ggi_visual_t vis,int s,int len,gcp_YCCcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->GetYCCGammaMap(vis, s, len, gammamap);
}	/* gcpGetYCCGammaMap */


int gcpSetYCCGammaMap(ggi_visual_t vis,int s,int len,gcp_YCCcolor *gammamap)
{
	return LIBGGI_GCPEXT(vis)->SetYCCGammaMap(vis, s, len, gammamap);
}	/* gcpSetYCCGammaMap */





/* Blending manipulation
 */

/* Color blending */
gcp_pixel gcpBlendColor(ggi_visual_t vis,
			const gcp_pixel *pix1,
			const gcp_pixel *pix2, uint16_t alpha)
{
	return LIBGGI_GCPEXT(vis)->BlendColor(vis, pix1, pix2, alpha);
}	/* gcpBlendColor */



/* Luminance manipulation
 */

ggi_float gcpGetLuminance(ggi_visual_t vis, const gcp_pixel pix)
{
	return LIBGGI_GCPEXT(vis)->GetLuminance(vis, pix);
}	/* gcpGetLuminance */



/* Lightness manipulation
 */

gcp_pixel gcpSetIntensity(ggi_visual_t vis, const gcp_pixel *pix1, const gcp_pixel *light_color)
{
	return LIBGGI_GCPEXT(vis)->SetIntensity(vis, pix1, light_color);
}	/* gcpSetIntensity */


gcp_pixel gcpGetIntensity(ggi_visual_t vis, const gcp_pixel *pix1, const gcp_pixel *pix2)
{
	return LIBGGI_GCPEXT(vis)->GetIntensity(vis, pix1, pix2);
}	/* gcpGetIntensity */
