/**
 * @file makearchive.c Creates an archive.
 * 
 * $Id: makearchive.c,v 1.3 2003/01/01 06:22:31 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/comprex.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef WITH_LEAKBUG
# include <leakbug.h>
#endif

int
main(int argc, char **argv)
{
	CxArchive *archive;
	CxDirectory *root;
	CxStatus status;
	int i;
	
	if (argc < 3)
	{
		printf("Syntax: makearchive archivefile filename...");
		exit(1);
	}

	archive = cxNewArchive();

	root = cxGetArchiveRoot(archive);

	for (i = 2; i < argc; i++)
	{
		CxFile *file;

		file = cxMakeFile(argv[i]);

		printf("Adding file: %s\n", cxGetFileName(file));

		cxDirAddFile(root, file);
	}

	printf("Archive filename: %s\n", argv[1]);
	status = cxSaveArchive(archive, argv[1]);

	if (status == CX_NOT_SUPPORTED)
	{
		fprintf(stderr, "Archive type not supported.\n");
	}
	else if (status == CX_ERROR)
	{
		fprintf(stderr, "Error saving archive.\n");
	}
	else if (status == CX_SUCCESS)
	{
		fprintf(stderr, "Archive saved to %s\n", cxGetArchiveFileName(archive));
	}
	else
	{
		fprintf(stderr, "Unknown error %d\n", status);
	}

	cxCloseArchive(archive);

	/* Clean up everything. We're done with libcomprex. */
	cxCleanup();

#ifdef WITH_LEAKBUG
	lbDumpLeaks();
#endif

	return 0;
}
