/**
 * @file catfile.c Displays the contents of the specified file.
 * 
 * $Id: catfile.c,v 1.3 2003/01/01 06:22:31 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/comprex.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef WITH_LEAKBUG
# include <leakbug.h>
#endif

int
main(int argc, char **argv)
{
	CxFP  *fp;
	char   buffer[4096];
	size_t s;

	if (argc < 2)
	{
		printf("You must specify a filename!\n");
		exit(1);
	}
	
	fp = cxOpenFile(argv[1], CX_MODE_READ_ONLY);

	if (fp == NULL)
	{
		printf("Unable to open the file!\n");
		exit(1);
	}

	while ((s = cxRead(buffer, sizeof(char), 4095, fp)) > 0)
	{
		buffer[s] = '\0';
		printf("%s", buffer);
	}
	
	cxClose(fp);

	/* Clean up everything. We're done with libcomprex. */
	cxCleanup();

#ifdef WITH_LEAKBUG
	lbDumpLeaks();
#endif

	return 0;
}
