/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
#ifndef Cassandra_H
#define Cassandra_H

#include <TProcessor.h>
#include "cassandra_types.h"

namespace org { namespace apache { namespace cassandra {

class CassandraIf {
 public:
  virtual ~CassandraIf() {}
  virtual void login(const std::string& keyspace, const AuthenticationRequest& auth_request) = 0;
  virtual void get(ColumnOrSuperColumn& _return, const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const ConsistencyLevel consistency_level) = 0;
  virtual void get_slice(std::vector<ColumnOrSuperColumn> & _return, const std::string& keyspace, const std::string& key, const ColumnParent& column_parent, const SlicePredicate& predicate, const ConsistencyLevel consistency_level) = 0;
  virtual void multiget(std::map<std::string, ColumnOrSuperColumn> & _return, const std::string& keyspace, const std::vector<std::string> & keys, const ColumnPath& column_path, const ConsistencyLevel consistency_level) = 0;
  virtual void multiget_slice(std::map<std::string, std::vector<ColumnOrSuperColumn> > & _return, const std::string& keyspace, const std::vector<std::string> & keys, const ColumnParent& column_parent, const SlicePredicate& predicate, const ConsistencyLevel consistency_level) = 0;
  virtual int32_t get_count(const std::string& keyspace, const std::string& key, const ColumnParent& column_parent, const ConsistencyLevel consistency_level) = 0;
  virtual void get_range_slice(std::vector<KeySlice> & _return, const std::string& keyspace, const ColumnParent& column_parent, const SlicePredicate& predicate, const std::string& start_key, const std::string& finish_key, const int32_t row_count, const ConsistencyLevel consistency_level) = 0;
  virtual void get_range_slices(std::vector<KeySlice> & _return, const std::string& keyspace, const ColumnParent& column_parent, const SlicePredicate& predicate, const KeyRange& range, const ConsistencyLevel consistency_level) = 0;
  virtual void insert(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const std::string& value, const int64_t timestamp, const ConsistencyLevel consistency_level) = 0;
  virtual void batch_insert(const std::string& keyspace, const std::string& key, const std::map<std::string, std::vector<ColumnOrSuperColumn> > & cfmap, const ConsistencyLevel consistency_level) = 0;
  virtual void remove(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const int64_t timestamp, const ConsistencyLevel consistency_level) = 0;
  virtual void batch_mutate(const std::string& keyspace, const std::map<std::string, std::map<std::string, std::vector<Mutation> > > & mutation_map, const ConsistencyLevel consistency_level) = 0;
  virtual void get_string_property(std::string& _return, const std::string& property) = 0;
  virtual void get_string_list_property(std::vector<std::string> & _return, const std::string& property) = 0;
  virtual void describe_keyspaces(std::set<std::string> & _return) = 0;
  virtual void describe_cluster_name(std::string& _return) = 0;
  virtual void describe_version(std::string& _return) = 0;
  virtual void describe_ring(std::vector<TokenRange> & _return, const std::string& keyspace) = 0;
  virtual void describe_partitioner(std::string& _return) = 0;
  virtual void describe_keyspace(std::map<std::string, std::map<std::string, std::string> > & _return, const std::string& keyspace) = 0;
  virtual void describe_splits(std::vector<std::string> & _return, const std::string& start_token, const std::string& end_token, const int32_t keys_per_split) = 0;
};

class CassandraNull : virtual public CassandraIf {
 public:
  virtual ~CassandraNull() {}
  void login(const std::string& /* keyspace */, const AuthenticationRequest& /* auth_request */) {
    return;
  }
  void get(ColumnOrSuperColumn& /* _return */, const std::string& /* keyspace */, const std::string& /* key */, const ColumnPath& /* column_path */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void get_slice(std::vector<ColumnOrSuperColumn> & /* _return */, const std::string& /* keyspace */, const std::string& /* key */, const ColumnParent& /* column_parent */, const SlicePredicate& /* predicate */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void multiget(std::map<std::string, ColumnOrSuperColumn> & /* _return */, const std::string& /* keyspace */, const std::vector<std::string> & /* keys */, const ColumnPath& /* column_path */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void multiget_slice(std::map<std::string, std::vector<ColumnOrSuperColumn> > & /* _return */, const std::string& /* keyspace */, const std::vector<std::string> & /* keys */, const ColumnParent& /* column_parent */, const SlicePredicate& /* predicate */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  int32_t get_count(const std::string& /* keyspace */, const std::string& /* key */, const ColumnParent& /* column_parent */, const ConsistencyLevel /* consistency_level */) {
    int32_t _return = 0;
    return _return;
  }
  void get_range_slice(std::vector<KeySlice> & /* _return */, const std::string& /* keyspace */, const ColumnParent& /* column_parent */, const SlicePredicate& /* predicate */, const std::string& /* start_key */, const std::string& /* finish_key */, const int32_t /* row_count */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void get_range_slices(std::vector<KeySlice> & /* _return */, const std::string& /* keyspace */, const ColumnParent& /* column_parent */, const SlicePredicate& /* predicate */, const KeyRange& /* range */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void insert(const std::string& /* keyspace */, const std::string& /* key */, const ColumnPath& /* column_path */, const std::string& /* value */, const int64_t /* timestamp */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void batch_insert(const std::string& /* keyspace */, const std::string& /* key */, const std::map<std::string, std::vector<ColumnOrSuperColumn> > & /* cfmap */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void remove(const std::string& /* keyspace */, const std::string& /* key */, const ColumnPath& /* column_path */, const int64_t /* timestamp */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void batch_mutate(const std::string& /* keyspace */, const std::map<std::string, std::map<std::string, std::vector<Mutation> > > & /* mutation_map */, const ConsistencyLevel /* consistency_level */) {
    return;
  }
  void get_string_property(std::string& /* _return */, const std::string& /* property */) {
    return;
  }
  void get_string_list_property(std::vector<std::string> & /* _return */, const std::string& /* property */) {
    return;
  }
  void describe_keyspaces(std::set<std::string> & /* _return */) {
    return;
  }
  void describe_cluster_name(std::string& /* _return */) {
    return;
  }
  void describe_version(std::string& /* _return */) {
    return;
  }
  void describe_ring(std::vector<TokenRange> & /* _return */, const std::string& /* keyspace */) {
    return;
  }
  void describe_partitioner(std::string& /* _return */) {
    return;
  }
  void describe_keyspace(std::map<std::string, std::map<std::string, std::string> > & /* _return */, const std::string& /* keyspace */) {
    return;
  }
  void describe_splits(std::vector<std::string> & /* _return */, const std::string& /* start_token */, const std::string& /* end_token */, const int32_t /* keys_per_split */) {
    return;
  }
};


class Cassandra_login_args {
 public:

  Cassandra_login_args() : keyspace("") {
  }

  virtual ~Cassandra_login_args() throw() {}

  std::string keyspace;
  AuthenticationRequest auth_request;

  bool operator == (const Cassandra_login_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(auth_request == rhs.auth_request))
      return false;
    return true;
  }
  bool operator != (const Cassandra_login_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_login_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_login_pargs {
 public:


  virtual ~Cassandra_login_pargs() throw() {}

  const std::string* keyspace;
  const AuthenticationRequest* auth_request;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_login_result__isset {
  _Cassandra_login_result__isset() : authnx(false), authzx(false) {}
  bool authnx;
  bool authzx;
} _Cassandra_login_result__isset;

class Cassandra_login_result {
 public:

  Cassandra_login_result() {
  }

  virtual ~Cassandra_login_result() throw() {}

  AuthenticationException authnx;
  AuthorizationException authzx;

  _Cassandra_login_result__isset __isset;

  bool operator == (const Cassandra_login_result & rhs) const
  {
    if (!(authnx == rhs.authnx))
      return false;
    if (!(authzx == rhs.authzx))
      return false;
    return true;
  }
  bool operator != (const Cassandra_login_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_login_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_login_presult__isset {
  _Cassandra_login_presult__isset() : authnx(false), authzx(false) {}
  bool authnx;
  bool authzx;
} _Cassandra_login_presult__isset;

class Cassandra_login_presult {
 public:


  virtual ~Cassandra_login_presult() throw() {}

  AuthenticationException authnx;
  AuthorizationException authzx;

  _Cassandra_login_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_get_args {
 public:

  Cassandra_get_args() : keyspace(""), key("") {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_get_args() throw() {}

  std::string keyspace;
  std::string key;
  ColumnPath column_path;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_get_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(key == rhs.key))
      return false;
    if (!(column_path == rhs.column_path))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_get_pargs {
 public:


  virtual ~Cassandra_get_pargs() throw() {}

  const std::string* keyspace;
  const std::string* key;
  const ColumnPath* column_path;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_result__isset {
  _Cassandra_get_result__isset() : success(false), ire(false), nfe(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool nfe;
  bool ue;
  bool te;
} _Cassandra_get_result__isset;

class Cassandra_get_result {
 public:

  Cassandra_get_result() {
  }

  virtual ~Cassandra_get_result() throw() {}

  ColumnOrSuperColumn success;
  InvalidRequestException ire;
  NotFoundException nfe;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_result__isset __isset;

  bool operator == (const Cassandra_get_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(nfe == rhs.nfe))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_presult__isset {
  _Cassandra_get_presult__isset() : success(false), ire(false), nfe(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool nfe;
  bool ue;
  bool te;
} _Cassandra_get_presult__isset;

class Cassandra_get_presult {
 public:


  virtual ~Cassandra_get_presult() throw() {}

  ColumnOrSuperColumn* success;
  InvalidRequestException ire;
  NotFoundException nfe;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_get_slice_args {
 public:

  Cassandra_get_slice_args() : keyspace(""), key("") {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_get_slice_args() throw() {}

  std::string keyspace;
  std::string key;
  ColumnParent column_parent;
  SlicePredicate predicate;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_get_slice_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(key == rhs.key))
      return false;
    if (!(column_parent == rhs.column_parent))
      return false;
    if (!(predicate == rhs.predicate))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_slice_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_slice_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_get_slice_pargs {
 public:


  virtual ~Cassandra_get_slice_pargs() throw() {}

  const std::string* keyspace;
  const std::string* key;
  const ColumnParent* column_parent;
  const SlicePredicate* predicate;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_slice_result__isset {
  _Cassandra_get_slice_result__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_get_slice_result__isset;

class Cassandra_get_slice_result {
 public:

  Cassandra_get_slice_result() {
  }

  virtual ~Cassandra_get_slice_result() throw() {}

  std::vector<ColumnOrSuperColumn>  success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_slice_result__isset __isset;

  bool operator == (const Cassandra_get_slice_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_slice_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_slice_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_slice_presult__isset {
  _Cassandra_get_slice_presult__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_get_slice_presult__isset;

class Cassandra_get_slice_presult {
 public:


  virtual ~Cassandra_get_slice_presult() throw() {}

  std::vector<ColumnOrSuperColumn> * success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_slice_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_multiget_args {
 public:

  Cassandra_multiget_args() : keyspace("") {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_multiget_args() throw() {}

  std::string keyspace;
  std::vector<std::string>  keys;
  ColumnPath column_path;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_multiget_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(keys == rhs.keys))
      return false;
    if (!(column_path == rhs.column_path))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_multiget_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_multiget_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_multiget_pargs {
 public:


  virtual ~Cassandra_multiget_pargs() throw() {}

  const std::string* keyspace;
  const std::vector<std::string> * keys;
  const ColumnPath* column_path;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_multiget_result__isset {
  _Cassandra_multiget_result__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_multiget_result__isset;

class Cassandra_multiget_result {
 public:

  Cassandra_multiget_result() {
  }

  virtual ~Cassandra_multiget_result() throw() {}

  std::map<std::string, ColumnOrSuperColumn>  success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_multiget_result__isset __isset;

  bool operator == (const Cassandra_multiget_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_multiget_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_multiget_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_multiget_presult__isset {
  _Cassandra_multiget_presult__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_multiget_presult__isset;

class Cassandra_multiget_presult {
 public:


  virtual ~Cassandra_multiget_presult() throw() {}

  std::map<std::string, ColumnOrSuperColumn> * success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_multiget_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_multiget_slice_args {
 public:

  Cassandra_multiget_slice_args() : keyspace("") {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_multiget_slice_args() throw() {}

  std::string keyspace;
  std::vector<std::string>  keys;
  ColumnParent column_parent;
  SlicePredicate predicate;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_multiget_slice_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(keys == rhs.keys))
      return false;
    if (!(column_parent == rhs.column_parent))
      return false;
    if (!(predicate == rhs.predicate))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_multiget_slice_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_multiget_slice_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_multiget_slice_pargs {
 public:


  virtual ~Cassandra_multiget_slice_pargs() throw() {}

  const std::string* keyspace;
  const std::vector<std::string> * keys;
  const ColumnParent* column_parent;
  const SlicePredicate* predicate;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_multiget_slice_result__isset {
  _Cassandra_multiget_slice_result__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_multiget_slice_result__isset;

class Cassandra_multiget_slice_result {
 public:

  Cassandra_multiget_slice_result() {
  }

  virtual ~Cassandra_multiget_slice_result() throw() {}

  std::map<std::string, std::vector<ColumnOrSuperColumn> >  success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_multiget_slice_result__isset __isset;

  bool operator == (const Cassandra_multiget_slice_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_multiget_slice_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_multiget_slice_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_multiget_slice_presult__isset {
  _Cassandra_multiget_slice_presult__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_multiget_slice_presult__isset;

class Cassandra_multiget_slice_presult {
 public:


  virtual ~Cassandra_multiget_slice_presult() throw() {}

  std::map<std::string, std::vector<ColumnOrSuperColumn> > * success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_multiget_slice_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_get_count_args {
 public:

  Cassandra_get_count_args() : keyspace(""), key("") {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_get_count_args() throw() {}

  std::string keyspace;
  std::string key;
  ColumnParent column_parent;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_get_count_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(key == rhs.key))
      return false;
    if (!(column_parent == rhs.column_parent))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_count_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_count_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_get_count_pargs {
 public:


  virtual ~Cassandra_get_count_pargs() throw() {}

  const std::string* keyspace;
  const std::string* key;
  const ColumnParent* column_parent;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_count_result__isset {
  _Cassandra_get_count_result__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_get_count_result__isset;

class Cassandra_get_count_result {
 public:

  Cassandra_get_count_result() : success(0) {
  }

  virtual ~Cassandra_get_count_result() throw() {}

  int32_t success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_count_result__isset __isset;

  bool operator == (const Cassandra_get_count_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_count_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_count_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_count_presult__isset {
  _Cassandra_get_count_presult__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_get_count_presult__isset;

class Cassandra_get_count_presult {
 public:


  virtual ~Cassandra_get_count_presult() throw() {}

  int32_t* success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_count_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_get_range_slice_args {
 public:

  Cassandra_get_range_slice_args() : keyspace(""), start_key(""), finish_key(""), row_count(100) {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_get_range_slice_args() throw() {}

  std::string keyspace;
  ColumnParent column_parent;
  SlicePredicate predicate;
  std::string start_key;
  std::string finish_key;
  int32_t row_count;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_get_range_slice_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(column_parent == rhs.column_parent))
      return false;
    if (!(predicate == rhs.predicate))
      return false;
    if (!(start_key == rhs.start_key))
      return false;
    if (!(finish_key == rhs.finish_key))
      return false;
    if (!(row_count == rhs.row_count))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_range_slice_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_range_slice_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_get_range_slice_pargs {
 public:


  virtual ~Cassandra_get_range_slice_pargs() throw() {}

  const std::string* keyspace;
  const ColumnParent* column_parent;
  const SlicePredicate* predicate;
  const std::string* start_key;
  const std::string* finish_key;
  const int32_t* row_count;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_range_slice_result__isset {
  _Cassandra_get_range_slice_result__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_get_range_slice_result__isset;

class Cassandra_get_range_slice_result {
 public:

  Cassandra_get_range_slice_result() {
  }

  virtual ~Cassandra_get_range_slice_result() throw() {}

  std::vector<KeySlice>  success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_range_slice_result__isset __isset;

  bool operator == (const Cassandra_get_range_slice_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_range_slice_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_range_slice_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_range_slice_presult__isset {
  _Cassandra_get_range_slice_presult__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_get_range_slice_presult__isset;

class Cassandra_get_range_slice_presult {
 public:


  virtual ~Cassandra_get_range_slice_presult() throw() {}

  std::vector<KeySlice> * success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_range_slice_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_get_range_slices_args {
 public:

  Cassandra_get_range_slices_args() : keyspace("") {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_get_range_slices_args() throw() {}

  std::string keyspace;
  ColumnParent column_parent;
  SlicePredicate predicate;
  KeyRange range;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_get_range_slices_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(column_parent == rhs.column_parent))
      return false;
    if (!(predicate == rhs.predicate))
      return false;
    if (!(range == rhs.range))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_range_slices_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_range_slices_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_get_range_slices_pargs {
 public:


  virtual ~Cassandra_get_range_slices_pargs() throw() {}

  const std::string* keyspace;
  const ColumnParent* column_parent;
  const SlicePredicate* predicate;
  const KeyRange* range;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_range_slices_result__isset {
  _Cassandra_get_range_slices_result__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_get_range_slices_result__isset;

class Cassandra_get_range_slices_result {
 public:

  Cassandra_get_range_slices_result() {
  }

  virtual ~Cassandra_get_range_slices_result() throw() {}

  std::vector<KeySlice>  success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_range_slices_result__isset __isset;

  bool operator == (const Cassandra_get_range_slices_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_range_slices_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_range_slices_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_range_slices_presult__isset {
  _Cassandra_get_range_slices_presult__isset() : success(false), ire(false), ue(false), te(false) {}
  bool success;
  bool ire;
  bool ue;
  bool te;
} _Cassandra_get_range_slices_presult__isset;

class Cassandra_get_range_slices_presult {
 public:


  virtual ~Cassandra_get_range_slices_presult() throw() {}

  std::vector<KeySlice> * success;
  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_get_range_slices_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_insert_args {
 public:

  Cassandra_insert_args() : keyspace(""), key(""), value(""), timestamp(0) {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_insert_args() throw() {}

  std::string keyspace;
  std::string key;
  ColumnPath column_path;
  std::string value;
  int64_t timestamp;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_insert_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(key == rhs.key))
      return false;
    if (!(column_path == rhs.column_path))
      return false;
    if (!(value == rhs.value))
      return false;
    if (!(timestamp == rhs.timestamp))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_insert_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_insert_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_insert_pargs {
 public:


  virtual ~Cassandra_insert_pargs() throw() {}

  const std::string* keyspace;
  const std::string* key;
  const ColumnPath* column_path;
  const std::string* value;
  const int64_t* timestamp;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_insert_result__isset {
  _Cassandra_insert_result__isset() : ire(false), ue(false), te(false) {}
  bool ire;
  bool ue;
  bool te;
} _Cassandra_insert_result__isset;

class Cassandra_insert_result {
 public:

  Cassandra_insert_result() {
  }

  virtual ~Cassandra_insert_result() throw() {}

  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_insert_result__isset __isset;

  bool operator == (const Cassandra_insert_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_insert_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_insert_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_insert_presult__isset {
  _Cassandra_insert_presult__isset() : ire(false), ue(false), te(false) {}
  bool ire;
  bool ue;
  bool te;
} _Cassandra_insert_presult__isset;

class Cassandra_insert_presult {
 public:


  virtual ~Cassandra_insert_presult() throw() {}

  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_insert_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_batch_insert_args {
 public:

  Cassandra_batch_insert_args() : keyspace(""), key("") {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_batch_insert_args() throw() {}

  std::string keyspace;
  std::string key;
  std::map<std::string, std::vector<ColumnOrSuperColumn> >  cfmap;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_batch_insert_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(key == rhs.key))
      return false;
    if (!(cfmap == rhs.cfmap))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_batch_insert_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_batch_insert_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_batch_insert_pargs {
 public:


  virtual ~Cassandra_batch_insert_pargs() throw() {}

  const std::string* keyspace;
  const std::string* key;
  const std::map<std::string, std::vector<ColumnOrSuperColumn> > * cfmap;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_batch_insert_result__isset {
  _Cassandra_batch_insert_result__isset() : ire(false), ue(false), te(false) {}
  bool ire;
  bool ue;
  bool te;
} _Cassandra_batch_insert_result__isset;

class Cassandra_batch_insert_result {
 public:

  Cassandra_batch_insert_result() {
  }

  virtual ~Cassandra_batch_insert_result() throw() {}

  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_batch_insert_result__isset __isset;

  bool operator == (const Cassandra_batch_insert_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_batch_insert_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_batch_insert_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_batch_insert_presult__isset {
  _Cassandra_batch_insert_presult__isset() : ire(false), ue(false), te(false) {}
  bool ire;
  bool ue;
  bool te;
} _Cassandra_batch_insert_presult__isset;

class Cassandra_batch_insert_presult {
 public:


  virtual ~Cassandra_batch_insert_presult() throw() {}

  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_batch_insert_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Cassandra_remove_args__isset {
  _Cassandra_remove_args__isset() : consistency_level(false) {}
  bool consistency_level;
} _Cassandra_remove_args__isset;

class Cassandra_remove_args {
 public:

  Cassandra_remove_args() : keyspace(""), key(""), timestamp(0) {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_remove_args() throw() {}

  std::string keyspace;
  std::string key;
  ColumnPath column_path;
  int64_t timestamp;
  ConsistencyLevel consistency_level;

  _Cassandra_remove_args__isset __isset;

  bool operator == (const Cassandra_remove_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(key == rhs.key))
      return false;
    if (!(column_path == rhs.column_path))
      return false;
    if (!(timestamp == rhs.timestamp))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_remove_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_remove_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_remove_pargs {
 public:


  virtual ~Cassandra_remove_pargs() throw() {}

  const std::string* keyspace;
  const std::string* key;
  const ColumnPath* column_path;
  const int64_t* timestamp;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_remove_result__isset {
  _Cassandra_remove_result__isset() : ire(false), ue(false), te(false) {}
  bool ire;
  bool ue;
  bool te;
} _Cassandra_remove_result__isset;

class Cassandra_remove_result {
 public:

  Cassandra_remove_result() {
  }

  virtual ~Cassandra_remove_result() throw() {}

  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_remove_result__isset __isset;

  bool operator == (const Cassandra_remove_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_remove_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_remove_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_remove_presult__isset {
  _Cassandra_remove_presult__isset() : ire(false), ue(false), te(false) {}
  bool ire;
  bool ue;
  bool te;
} _Cassandra_remove_presult__isset;

class Cassandra_remove_presult {
 public:


  virtual ~Cassandra_remove_presult() throw() {}

  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_remove_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_batch_mutate_args {
 public:

  Cassandra_batch_mutate_args() : keyspace("") {
    consistency_level = (ConsistencyLevel)1;

  }

  virtual ~Cassandra_batch_mutate_args() throw() {}

  std::string keyspace;
  std::map<std::string, std::map<std::string, std::vector<Mutation> > >  mutation_map;
  ConsistencyLevel consistency_level;

  bool operator == (const Cassandra_batch_mutate_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    if (!(mutation_map == rhs.mutation_map))
      return false;
    if (!(consistency_level == rhs.consistency_level))
      return false;
    return true;
  }
  bool operator != (const Cassandra_batch_mutate_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_batch_mutate_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_batch_mutate_pargs {
 public:


  virtual ~Cassandra_batch_mutate_pargs() throw() {}

  const std::string* keyspace;
  const std::map<std::string, std::map<std::string, std::vector<Mutation> > > * mutation_map;
  const ConsistencyLevel* consistency_level;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_batch_mutate_result__isset {
  _Cassandra_batch_mutate_result__isset() : ire(false), ue(false), te(false) {}
  bool ire;
  bool ue;
  bool te;
} _Cassandra_batch_mutate_result__isset;

class Cassandra_batch_mutate_result {
 public:

  Cassandra_batch_mutate_result() {
  }

  virtual ~Cassandra_batch_mutate_result() throw() {}

  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_batch_mutate_result__isset __isset;

  bool operator == (const Cassandra_batch_mutate_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(ue == rhs.ue))
      return false;
    if (!(te == rhs.te))
      return false;
    return true;
  }
  bool operator != (const Cassandra_batch_mutate_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_batch_mutate_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_batch_mutate_presult__isset {
  _Cassandra_batch_mutate_presult__isset() : ire(false), ue(false), te(false) {}
  bool ire;
  bool ue;
  bool te;
} _Cassandra_batch_mutate_presult__isset;

class Cassandra_batch_mutate_presult {
 public:


  virtual ~Cassandra_batch_mutate_presult() throw() {}

  InvalidRequestException ire;
  UnavailableException ue;
  TimedOutException te;

  _Cassandra_batch_mutate_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_get_string_property_args {
 public:

  Cassandra_get_string_property_args() : property("") {
  }

  virtual ~Cassandra_get_string_property_args() throw() {}

  std::string property;

  bool operator == (const Cassandra_get_string_property_args & rhs) const
  {
    if (!(property == rhs.property))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_string_property_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_string_property_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_get_string_property_pargs {
 public:


  virtual ~Cassandra_get_string_property_pargs() throw() {}

  const std::string* property;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_string_property_result__isset {
  _Cassandra_get_string_property_result__isset() : success(false) {}
  bool success;
} _Cassandra_get_string_property_result__isset;

class Cassandra_get_string_property_result {
 public:

  Cassandra_get_string_property_result() : success("") {
  }

  virtual ~Cassandra_get_string_property_result() throw() {}

  std::string success;

  _Cassandra_get_string_property_result__isset __isset;

  bool operator == (const Cassandra_get_string_property_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_string_property_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_string_property_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_string_property_presult__isset {
  _Cassandra_get_string_property_presult__isset() : success(false) {}
  bool success;
} _Cassandra_get_string_property_presult__isset;

class Cassandra_get_string_property_presult {
 public:


  virtual ~Cassandra_get_string_property_presult() throw() {}

  std::string* success;

  _Cassandra_get_string_property_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_get_string_list_property_args {
 public:

  Cassandra_get_string_list_property_args() : property("") {
  }

  virtual ~Cassandra_get_string_list_property_args() throw() {}

  std::string property;

  bool operator == (const Cassandra_get_string_list_property_args & rhs) const
  {
    if (!(property == rhs.property))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_string_list_property_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_string_list_property_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_get_string_list_property_pargs {
 public:


  virtual ~Cassandra_get_string_list_property_pargs() throw() {}

  const std::string* property;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_string_list_property_result__isset {
  _Cassandra_get_string_list_property_result__isset() : success(false) {}
  bool success;
} _Cassandra_get_string_list_property_result__isset;

class Cassandra_get_string_list_property_result {
 public:

  Cassandra_get_string_list_property_result() {
  }

  virtual ~Cassandra_get_string_list_property_result() throw() {}

  std::vector<std::string>  success;

  _Cassandra_get_string_list_property_result__isset __isset;

  bool operator == (const Cassandra_get_string_list_property_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    return true;
  }
  bool operator != (const Cassandra_get_string_list_property_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_get_string_list_property_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_get_string_list_property_presult__isset {
  _Cassandra_get_string_list_property_presult__isset() : success(false) {}
  bool success;
} _Cassandra_get_string_list_property_presult__isset;

class Cassandra_get_string_list_property_presult {
 public:


  virtual ~Cassandra_get_string_list_property_presult() throw() {}

  std::vector<std::string> * success;

  _Cassandra_get_string_list_property_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_describe_keyspaces_args {
 public:

  Cassandra_describe_keyspaces_args() {
  }

  virtual ~Cassandra_describe_keyspaces_args() throw() {}


  bool operator == (const Cassandra_describe_keyspaces_args & /* rhs */) const
  {
    return true;
  }
  bool operator != (const Cassandra_describe_keyspaces_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_keyspaces_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_describe_keyspaces_pargs {
 public:


  virtual ~Cassandra_describe_keyspaces_pargs() throw() {}


  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_keyspaces_result__isset {
  _Cassandra_describe_keyspaces_result__isset() : success(false) {}
  bool success;
} _Cassandra_describe_keyspaces_result__isset;

class Cassandra_describe_keyspaces_result {
 public:

  Cassandra_describe_keyspaces_result() {
  }

  virtual ~Cassandra_describe_keyspaces_result() throw() {}

  std::set<std::string>  success;

  _Cassandra_describe_keyspaces_result__isset __isset;

  bool operator == (const Cassandra_describe_keyspaces_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_keyspaces_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_keyspaces_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_keyspaces_presult__isset {
  _Cassandra_describe_keyspaces_presult__isset() : success(false) {}
  bool success;
} _Cassandra_describe_keyspaces_presult__isset;

class Cassandra_describe_keyspaces_presult {
 public:


  virtual ~Cassandra_describe_keyspaces_presult() throw() {}

  std::set<std::string> * success;

  _Cassandra_describe_keyspaces_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_describe_cluster_name_args {
 public:

  Cassandra_describe_cluster_name_args() {
  }

  virtual ~Cassandra_describe_cluster_name_args() throw() {}


  bool operator == (const Cassandra_describe_cluster_name_args & /* rhs */) const
  {
    return true;
  }
  bool operator != (const Cassandra_describe_cluster_name_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_cluster_name_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_describe_cluster_name_pargs {
 public:


  virtual ~Cassandra_describe_cluster_name_pargs() throw() {}


  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_cluster_name_result__isset {
  _Cassandra_describe_cluster_name_result__isset() : success(false) {}
  bool success;
} _Cassandra_describe_cluster_name_result__isset;

class Cassandra_describe_cluster_name_result {
 public:

  Cassandra_describe_cluster_name_result() : success("") {
  }

  virtual ~Cassandra_describe_cluster_name_result() throw() {}

  std::string success;

  _Cassandra_describe_cluster_name_result__isset __isset;

  bool operator == (const Cassandra_describe_cluster_name_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_cluster_name_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_cluster_name_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_cluster_name_presult__isset {
  _Cassandra_describe_cluster_name_presult__isset() : success(false) {}
  bool success;
} _Cassandra_describe_cluster_name_presult__isset;

class Cassandra_describe_cluster_name_presult {
 public:


  virtual ~Cassandra_describe_cluster_name_presult() throw() {}

  std::string* success;

  _Cassandra_describe_cluster_name_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_describe_version_args {
 public:

  Cassandra_describe_version_args() {
  }

  virtual ~Cassandra_describe_version_args() throw() {}


  bool operator == (const Cassandra_describe_version_args & /* rhs */) const
  {
    return true;
  }
  bool operator != (const Cassandra_describe_version_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_version_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_describe_version_pargs {
 public:


  virtual ~Cassandra_describe_version_pargs() throw() {}


  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_version_result__isset {
  _Cassandra_describe_version_result__isset() : success(false) {}
  bool success;
} _Cassandra_describe_version_result__isset;

class Cassandra_describe_version_result {
 public:

  Cassandra_describe_version_result() : success("") {
  }

  virtual ~Cassandra_describe_version_result() throw() {}

  std::string success;

  _Cassandra_describe_version_result__isset __isset;

  bool operator == (const Cassandra_describe_version_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_version_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_version_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_version_presult__isset {
  _Cassandra_describe_version_presult__isset() : success(false) {}
  bool success;
} _Cassandra_describe_version_presult__isset;

class Cassandra_describe_version_presult {
 public:


  virtual ~Cassandra_describe_version_presult() throw() {}

  std::string* success;

  _Cassandra_describe_version_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_describe_ring_args {
 public:

  Cassandra_describe_ring_args() : keyspace("") {
  }

  virtual ~Cassandra_describe_ring_args() throw() {}

  std::string keyspace;

  bool operator == (const Cassandra_describe_ring_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_ring_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_ring_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_describe_ring_pargs {
 public:


  virtual ~Cassandra_describe_ring_pargs() throw() {}

  const std::string* keyspace;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_ring_result__isset {
  _Cassandra_describe_ring_result__isset() : success(false), ire(false) {}
  bool success;
  bool ire;
} _Cassandra_describe_ring_result__isset;

class Cassandra_describe_ring_result {
 public:

  Cassandra_describe_ring_result() {
  }

  virtual ~Cassandra_describe_ring_result() throw() {}

  std::vector<TokenRange>  success;
  InvalidRequestException ire;

  _Cassandra_describe_ring_result__isset __isset;

  bool operator == (const Cassandra_describe_ring_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_ring_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_ring_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_ring_presult__isset {
  _Cassandra_describe_ring_presult__isset() : success(false), ire(false) {}
  bool success;
  bool ire;
} _Cassandra_describe_ring_presult__isset;

class Cassandra_describe_ring_presult {
 public:


  virtual ~Cassandra_describe_ring_presult() throw() {}

  std::vector<TokenRange> * success;
  InvalidRequestException ire;

  _Cassandra_describe_ring_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_describe_partitioner_args {
 public:

  Cassandra_describe_partitioner_args() {
  }

  virtual ~Cassandra_describe_partitioner_args() throw() {}


  bool operator == (const Cassandra_describe_partitioner_args & /* rhs */) const
  {
    return true;
  }
  bool operator != (const Cassandra_describe_partitioner_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_partitioner_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_describe_partitioner_pargs {
 public:


  virtual ~Cassandra_describe_partitioner_pargs() throw() {}


  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_partitioner_result__isset {
  _Cassandra_describe_partitioner_result__isset() : success(false) {}
  bool success;
} _Cassandra_describe_partitioner_result__isset;

class Cassandra_describe_partitioner_result {
 public:

  Cassandra_describe_partitioner_result() : success("") {
  }

  virtual ~Cassandra_describe_partitioner_result() throw() {}

  std::string success;

  _Cassandra_describe_partitioner_result__isset __isset;

  bool operator == (const Cassandra_describe_partitioner_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_partitioner_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_partitioner_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_partitioner_presult__isset {
  _Cassandra_describe_partitioner_presult__isset() : success(false) {}
  bool success;
} _Cassandra_describe_partitioner_presult__isset;

class Cassandra_describe_partitioner_presult {
 public:


  virtual ~Cassandra_describe_partitioner_presult() throw() {}

  std::string* success;

  _Cassandra_describe_partitioner_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_describe_keyspace_args {
 public:

  Cassandra_describe_keyspace_args() : keyspace("") {
  }

  virtual ~Cassandra_describe_keyspace_args() throw() {}

  std::string keyspace;

  bool operator == (const Cassandra_describe_keyspace_args & rhs) const
  {
    if (!(keyspace == rhs.keyspace))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_keyspace_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_keyspace_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_describe_keyspace_pargs {
 public:


  virtual ~Cassandra_describe_keyspace_pargs() throw() {}

  const std::string* keyspace;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_keyspace_result__isset {
  _Cassandra_describe_keyspace_result__isset() : success(false), nfe(false) {}
  bool success;
  bool nfe;
} _Cassandra_describe_keyspace_result__isset;

class Cassandra_describe_keyspace_result {
 public:

  Cassandra_describe_keyspace_result() {
  }

  virtual ~Cassandra_describe_keyspace_result() throw() {}

  std::map<std::string, std::map<std::string, std::string> >  success;
  NotFoundException nfe;

  _Cassandra_describe_keyspace_result__isset __isset;

  bool operator == (const Cassandra_describe_keyspace_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(nfe == rhs.nfe))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_keyspace_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_keyspace_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_keyspace_presult__isset {
  _Cassandra_describe_keyspace_presult__isset() : success(false), nfe(false) {}
  bool success;
  bool nfe;
} _Cassandra_describe_keyspace_presult__isset;

class Cassandra_describe_keyspace_presult {
 public:


  virtual ~Cassandra_describe_keyspace_presult() throw() {}

  std::map<std::string, std::map<std::string, std::string> > * success;
  NotFoundException nfe;

  _Cassandra_describe_keyspace_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Cassandra_describe_splits_args {
 public:

  Cassandra_describe_splits_args() : start_token(""), end_token(""), keys_per_split(0) {
  }

  virtual ~Cassandra_describe_splits_args() throw() {}

  std::string start_token;
  std::string end_token;
  int32_t keys_per_split;

  bool operator == (const Cassandra_describe_splits_args & rhs) const
  {
    if (!(start_token == rhs.start_token))
      return false;
    if (!(end_token == rhs.end_token))
      return false;
    if (!(keys_per_split == rhs.keys_per_split))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_splits_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_splits_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Cassandra_describe_splits_pargs {
 public:


  virtual ~Cassandra_describe_splits_pargs() throw() {}

  const std::string* start_token;
  const std::string* end_token;
  const int32_t* keys_per_split;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_splits_result__isset {
  _Cassandra_describe_splits_result__isset() : success(false) {}
  bool success;
} _Cassandra_describe_splits_result__isset;

class Cassandra_describe_splits_result {
 public:

  Cassandra_describe_splits_result() {
  }

  virtual ~Cassandra_describe_splits_result() throw() {}

  std::vector<std::string>  success;

  _Cassandra_describe_splits_result__isset __isset;

  bool operator == (const Cassandra_describe_splits_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    return true;
  }
  bool operator != (const Cassandra_describe_splits_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Cassandra_describe_splits_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Cassandra_describe_splits_presult__isset {
  _Cassandra_describe_splits_presult__isset() : success(false) {}
  bool success;
} _Cassandra_describe_splits_presult__isset;

class Cassandra_describe_splits_presult {
 public:


  virtual ~Cassandra_describe_splits_presult() throw() {}

  std::vector<std::string> * success;

  _Cassandra_describe_splits_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class CassandraClient : virtual public CassandraIf {
 public:
  CassandraClient(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> prot) :
    piprot_(prot),
    poprot_(prot) {
    iprot_ = prot.get();
    oprot_ = prot.get();
  }
  CassandraClient(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> iprot, boost::shared_ptr< ::apache::thrift::protocol::TProtocol> oprot) :
    piprot_(iprot),
    poprot_(oprot) {
    iprot_ = iprot.get();
    oprot_ = oprot.get();
  }
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> getInputProtocol() {
    return piprot_;
  }
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> getOutputProtocol() {
    return poprot_;
  }
  void login(const std::string& keyspace, const AuthenticationRequest& auth_request);
  void send_login(const std::string& keyspace, const AuthenticationRequest& auth_request);
  void recv_login();
  void get(ColumnOrSuperColumn& _return, const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const ConsistencyLevel consistency_level);
  void send_get(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const ConsistencyLevel consistency_level);
  void recv_get(ColumnOrSuperColumn& _return);
  void get_slice(std::vector<ColumnOrSuperColumn> & _return, const std::string& keyspace, const std::string& key, const ColumnParent& column_parent, const SlicePredicate& predicate, const ConsistencyLevel consistency_level);
  void send_get_slice(const std::string& keyspace, const std::string& key, const ColumnParent& column_parent, const SlicePredicate& predicate, const ConsistencyLevel consistency_level);
  void recv_get_slice(std::vector<ColumnOrSuperColumn> & _return);
  void multiget(std::map<std::string, ColumnOrSuperColumn> & _return, const std::string& keyspace, const std::vector<std::string> & keys, const ColumnPath& column_path, const ConsistencyLevel consistency_level);
  void send_multiget(const std::string& keyspace, const std::vector<std::string> & keys, const ColumnPath& column_path, const ConsistencyLevel consistency_level);
  void recv_multiget(std::map<std::string, ColumnOrSuperColumn> & _return);
  void multiget_slice(std::map<std::string, std::vector<ColumnOrSuperColumn> > & _return, const std::string& keyspace, const std::vector<std::string> & keys, const ColumnParent& column_parent, const SlicePredicate& predicate, const ConsistencyLevel consistency_level);
  void send_multiget_slice(const std::string& keyspace, const std::vector<std::string> & keys, const ColumnParent& column_parent, const SlicePredicate& predicate, const ConsistencyLevel consistency_level);
  void recv_multiget_slice(std::map<std::string, std::vector<ColumnOrSuperColumn> > & _return);
  int32_t get_count(const std::string& keyspace, const std::string& key, const ColumnParent& column_parent, const ConsistencyLevel consistency_level);
  void send_get_count(const std::string& keyspace, const std::string& key, const ColumnParent& column_parent, const ConsistencyLevel consistency_level);
  int32_t recv_get_count();
  void get_range_slice(std::vector<KeySlice> & _return, const std::string& keyspace, const ColumnParent& column_parent, const SlicePredicate& predicate, const std::string& start_key, const std::string& finish_key, const int32_t row_count, const ConsistencyLevel consistency_level);
  void send_get_range_slice(const std::string& keyspace, const ColumnParent& column_parent, const SlicePredicate& predicate, const std::string& start_key, const std::string& finish_key, const int32_t row_count, const ConsistencyLevel consistency_level);
  void recv_get_range_slice(std::vector<KeySlice> & _return);
  void get_range_slices(std::vector<KeySlice> & _return, const std::string& keyspace, const ColumnParent& column_parent, const SlicePredicate& predicate, const KeyRange& range, const ConsistencyLevel consistency_level);
  void send_get_range_slices(const std::string& keyspace, const ColumnParent& column_parent, const SlicePredicate& predicate, const KeyRange& range, const ConsistencyLevel consistency_level);
  void recv_get_range_slices(std::vector<KeySlice> & _return);
  void insert(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const std::string& value, const int64_t timestamp, const ConsistencyLevel consistency_level);
  void send_insert(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const std::string& value, const int64_t timestamp, const ConsistencyLevel consistency_level);
  void recv_insert();
  void batch_insert(const std::string& keyspace, const std::string& key, const std::map<std::string, std::vector<ColumnOrSuperColumn> > & cfmap, const ConsistencyLevel consistency_level);
  void send_batch_insert(const std::string& keyspace, const std::string& key, const std::map<std::string, std::vector<ColumnOrSuperColumn> > & cfmap, const ConsistencyLevel consistency_level);
  void recv_batch_insert();
  void remove(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const int64_t timestamp, const ConsistencyLevel consistency_level);
  void send_remove(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const int64_t timestamp, const ConsistencyLevel consistency_level);
  void recv_remove();
  void batch_mutate(const std::string& keyspace, const std::map<std::string, std::map<std::string, std::vector<Mutation> > > & mutation_map, const ConsistencyLevel consistency_level);
  void send_batch_mutate(const std::string& keyspace, const std::map<std::string, std::map<std::string, std::vector<Mutation> > > & mutation_map, const ConsistencyLevel consistency_level);
  void recv_batch_mutate();
  void get_string_property(std::string& _return, const std::string& property);
  void send_get_string_property(const std::string& property);
  void recv_get_string_property(std::string& _return);
  void get_string_list_property(std::vector<std::string> & _return, const std::string& property);
  void send_get_string_list_property(const std::string& property);
  void recv_get_string_list_property(std::vector<std::string> & _return);
  void describe_keyspaces(std::set<std::string> & _return);
  void send_describe_keyspaces();
  void recv_describe_keyspaces(std::set<std::string> & _return);
  void describe_cluster_name(std::string& _return);
  void send_describe_cluster_name();
  void recv_describe_cluster_name(std::string& _return);
  void describe_version(std::string& _return);
  void send_describe_version();
  void recv_describe_version(std::string& _return);
  void describe_ring(std::vector<TokenRange> & _return, const std::string& keyspace);
  void send_describe_ring(const std::string& keyspace);
  void recv_describe_ring(std::vector<TokenRange> & _return);
  void describe_partitioner(std::string& _return);
  void send_describe_partitioner();
  void recv_describe_partitioner(std::string& _return);
  void describe_keyspace(std::map<std::string, std::map<std::string, std::string> > & _return, const std::string& keyspace);
  void send_describe_keyspace(const std::string& keyspace);
  void recv_describe_keyspace(std::map<std::string, std::map<std::string, std::string> > & _return);
  void describe_splits(std::vector<std::string> & _return, const std::string& start_token, const std::string& end_token, const int32_t keys_per_split);
  void send_describe_splits(const std::string& start_token, const std::string& end_token, const int32_t keys_per_split);
  void recv_describe_splits(std::vector<std::string> & _return);
 protected:
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> piprot_;
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> poprot_;
  ::apache::thrift::protocol::TProtocol* iprot_;
  ::apache::thrift::protocol::TProtocol* oprot_;
};

class CassandraProcessor : virtual public ::apache::thrift::TProcessor {
 protected:
  boost::shared_ptr<CassandraIf> iface_;
  virtual bool process_fn(::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, std::string& fname, int32_t seqid);
 private:
  std::map<std::string, void (CassandraProcessor::*)(int32_t, ::apache::thrift::protocol::TProtocol*, ::apache::thrift::protocol::TProtocol*)> processMap_;
  void process_login(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_get(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_get_slice(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_multiget(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_multiget_slice(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_get_count(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_get_range_slice(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_get_range_slices(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_insert(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_batch_insert(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_remove(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_batch_mutate(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_get_string_property(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_get_string_list_property(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_describe_keyspaces(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_describe_cluster_name(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_describe_version(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_describe_ring(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_describe_partitioner(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_describe_keyspace(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_describe_splits(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
 public:
  CassandraProcessor(boost::shared_ptr<CassandraIf> iface) :
    iface_(iface) {
    processMap_["login"] = &CassandraProcessor::process_login;
    processMap_["get"] = &CassandraProcessor::process_get;
    processMap_["get_slice"] = &CassandraProcessor::process_get_slice;
    processMap_["multiget"] = &CassandraProcessor::process_multiget;
    processMap_["multiget_slice"] = &CassandraProcessor::process_multiget_slice;
    processMap_["get_count"] = &CassandraProcessor::process_get_count;
    processMap_["get_range_slice"] = &CassandraProcessor::process_get_range_slice;
    processMap_["get_range_slices"] = &CassandraProcessor::process_get_range_slices;
    processMap_["insert"] = &CassandraProcessor::process_insert;
    processMap_["batch_insert"] = &CassandraProcessor::process_batch_insert;
    processMap_["remove"] = &CassandraProcessor::process_remove;
    processMap_["batch_mutate"] = &CassandraProcessor::process_batch_mutate;
    processMap_["get_string_property"] = &CassandraProcessor::process_get_string_property;
    processMap_["get_string_list_property"] = &CassandraProcessor::process_get_string_list_property;
    processMap_["describe_keyspaces"] = &CassandraProcessor::process_describe_keyspaces;
    processMap_["describe_cluster_name"] = &CassandraProcessor::process_describe_cluster_name;
    processMap_["describe_version"] = &CassandraProcessor::process_describe_version;
    processMap_["describe_ring"] = &CassandraProcessor::process_describe_ring;
    processMap_["describe_partitioner"] = &CassandraProcessor::process_describe_partitioner;
    processMap_["describe_keyspace"] = &CassandraProcessor::process_describe_keyspace;
    processMap_["describe_splits"] = &CassandraProcessor::process_describe_splits;
  }

  virtual bool process(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> piprot, boost::shared_ptr< ::apache::thrift::protocol::TProtocol> poprot);
  virtual ~CassandraProcessor() {}
};

class CassandraMultiface : virtual public CassandraIf {
 public:
  CassandraMultiface(std::vector<boost::shared_ptr<CassandraIf> >& ifaces) : ifaces_(ifaces) {
  }
  virtual ~CassandraMultiface() {}
 protected:
  std::vector<boost::shared_ptr<CassandraIf> > ifaces_;
  CassandraMultiface() {}
  void add(boost::shared_ptr<CassandraIf> iface) {
    ifaces_.push_back(iface);
  }
 public:
  void login(const std::string& keyspace, const AuthenticationRequest& auth_request) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      ifaces_[i]->login(keyspace, auth_request);
    }
  }

  void get(ColumnOrSuperColumn& _return, const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->get(_return, keyspace, key, column_path, consistency_level);
        return;
      } else {
        ifaces_[i]->get(_return, keyspace, key, column_path, consistency_level);
      }
    }
  }

  void get_slice(std::vector<ColumnOrSuperColumn> & _return, const std::string& keyspace, const std::string& key, const ColumnParent& column_parent, const SlicePredicate& predicate, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->get_slice(_return, keyspace, key, column_parent, predicate, consistency_level);
        return;
      } else {
        ifaces_[i]->get_slice(_return, keyspace, key, column_parent, predicate, consistency_level);
      }
    }
  }

  void multiget(std::map<std::string, ColumnOrSuperColumn> & _return, const std::string& keyspace, const std::vector<std::string> & keys, const ColumnPath& column_path, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->multiget(_return, keyspace, keys, column_path, consistency_level);
        return;
      } else {
        ifaces_[i]->multiget(_return, keyspace, keys, column_path, consistency_level);
      }
    }
  }

  void multiget_slice(std::map<std::string, std::vector<ColumnOrSuperColumn> > & _return, const std::string& keyspace, const std::vector<std::string> & keys, const ColumnParent& column_parent, const SlicePredicate& predicate, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->multiget_slice(_return, keyspace, keys, column_parent, predicate, consistency_level);
        return;
      } else {
        ifaces_[i]->multiget_slice(_return, keyspace, keys, column_parent, predicate, consistency_level);
      }
    }
  }

  int32_t get_count(const std::string& keyspace, const std::string& key, const ColumnParent& column_parent, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->get_count(keyspace, key, column_parent, consistency_level);
      } else {
        ifaces_[i]->get_count(keyspace, key, column_parent, consistency_level);
      }
    }
  }

  void get_range_slice(std::vector<KeySlice> & _return, const std::string& keyspace, const ColumnParent& column_parent, const SlicePredicate& predicate, const std::string& start_key, const std::string& finish_key, const int32_t row_count, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->get_range_slice(_return, keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level);
        return;
      } else {
        ifaces_[i]->get_range_slice(_return, keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level);
      }
    }
  }

  void get_range_slices(std::vector<KeySlice> & _return, const std::string& keyspace, const ColumnParent& column_parent, const SlicePredicate& predicate, const KeyRange& range, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->get_range_slices(_return, keyspace, column_parent, predicate, range, consistency_level);
        return;
      } else {
        ifaces_[i]->get_range_slices(_return, keyspace, column_parent, predicate, range, consistency_level);
      }
    }
  }

  void insert(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const std::string& value, const int64_t timestamp, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      ifaces_[i]->insert(keyspace, key, column_path, value, timestamp, consistency_level);
    }
  }

  void batch_insert(const std::string& keyspace, const std::string& key, const std::map<std::string, std::vector<ColumnOrSuperColumn> > & cfmap, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      ifaces_[i]->batch_insert(keyspace, key, cfmap, consistency_level);
    }
  }

  void remove(const std::string& keyspace, const std::string& key, const ColumnPath& column_path, const int64_t timestamp, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      ifaces_[i]->remove(keyspace, key, column_path, timestamp, consistency_level);
    }
  }

  void batch_mutate(const std::string& keyspace, const std::map<std::string, std::map<std::string, std::vector<Mutation> > > & mutation_map, const ConsistencyLevel consistency_level) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      ifaces_[i]->batch_mutate(keyspace, mutation_map, consistency_level);
    }
  }

  void get_string_property(std::string& _return, const std::string& property) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->get_string_property(_return, property);
        return;
      } else {
        ifaces_[i]->get_string_property(_return, property);
      }
    }
  }

  void get_string_list_property(std::vector<std::string> & _return, const std::string& property) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->get_string_list_property(_return, property);
        return;
      } else {
        ifaces_[i]->get_string_list_property(_return, property);
      }
    }
  }

  void describe_keyspaces(std::set<std::string> & _return) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->describe_keyspaces(_return);
        return;
      } else {
        ifaces_[i]->describe_keyspaces(_return);
      }
    }
  }

  void describe_cluster_name(std::string& _return) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->describe_cluster_name(_return);
        return;
      } else {
        ifaces_[i]->describe_cluster_name(_return);
      }
    }
  }

  void describe_version(std::string& _return) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->describe_version(_return);
        return;
      } else {
        ifaces_[i]->describe_version(_return);
      }
    }
  }

  void describe_ring(std::vector<TokenRange> & _return, const std::string& keyspace) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->describe_ring(_return, keyspace);
        return;
      } else {
        ifaces_[i]->describe_ring(_return, keyspace);
      }
    }
  }

  void describe_partitioner(std::string& _return) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->describe_partitioner(_return);
        return;
      } else {
        ifaces_[i]->describe_partitioner(_return);
      }
    }
  }

  void describe_keyspace(std::map<std::string, std::map<std::string, std::string> > & _return, const std::string& keyspace) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->describe_keyspace(_return, keyspace);
        return;
      } else {
        ifaces_[i]->describe_keyspace(_return, keyspace);
      }
    }
  }

  void describe_splits(std::vector<std::string> & _return, const std::string& start_token, const std::string& end_token, const int32_t keys_per_split) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->describe_splits(_return, start_token, end_token, keys_per_split);
        return;
      } else {
        ifaces_[i]->describe_splits(_return, start_token, end_token, keys_per_split);
      }
    }
  }

};

}}} // namespace

#endif
