#
# libbegemot rpm spec file.
#
# $Begemot: libbegemot/libbegemot.spec,v 1.3 2005/06/01 07:50:51 brandt_h Exp $
#
# Authors:
#	Eric Moret
#	Harti Brandt
#
%ifos Linux
%define _prefix	/usr
%else
%define _prefix	/usr/local
%endif
%define _mandir	%{_prefix}/man

Name: libbegemot

Version: 1.11
# %define patchlevel f
Release: 3

Group: System Environment/Libraries
Copyright: Computer Begemot Associates
Source: ftp://ftp.fokus.gmd.de/pub/cats/usr/harti/p11/libbegemot-%{version}%{patchlevel}.tar.gz
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-buildroot
Provides: libbegemot
Summary: Begemot library.

%description
This is the begemot utility function library. It is needed to build most of the begemot tools.

%package devel
Group: Development/Libraries
Summary: Files needed for developing applications which use Libbegemot.
Requires: %{name} = %{version}-%{release}

%description devel
The libbegemot-devel package contains header files, static libraries, and other files useful for developing applications with libbegemot.

%prep
%setup -q -n%{name}-%{version}%{patchlevel}

%build
%configure
gmake

%clean
rm -fr $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
gmake install DESTDIR=$RPM_BUILD_ROOT

LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_libdir}:${LD_LIBRARY_PATH}
export LD_LIBRARY_PATH

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%attr(0755,root,root) %{_libdir}/*.so*

%files devel
%defattr(-,root,root)
%attr(0755,root,root) %dir %{_includedir}
%attr(0755,root,root) %dir %{_mandir}
%attr(0755,root,root) %dir %{_mandir}/manl
%attr(0755,root,root) %dir %{_libdir}
%attr(0444,root,root) %{_includedir}/*.h
%attr(0444,root,root) %{_mandir}/manl/*
%attr(0444,root,root) %{_libdir}/libbegemot.a
%attr(0444,root,root) %{_libdir}/libbegemot.la

%changelog
* Tue Sep 03 2002 Harti Brandt <brandt@fokus.gmd.de> 1.10-3
- make the prefix depend on the OS
- remove the *.so libraries from the devel package. They are already
  in the normal package and that one is required by devel
- make the patch level appear in the tar file name and the source directory
  but not in the package name. We will simply bump the patch level and
  the spec file revision level each time together. This will be sufficient
  for both rpm and non-rpm builds.
* Fri Aug 30 2002 Harti Brandt <brandt@fokus.gmd.de>
- make spec file to honor Prefix
- remove lang stuff
- include man pages into the devel package
- some tweaks here and there
* Sun Aug 18 2002 Eric Moret <eric.moret@epita.fr>
- derived spec file from libuser
* Wed Jun 12 2002 Eric Moret <eric.moret@epita.fr>
- initial spec file
