#ifndef __LHS_H
#define __LHS_H

#include "content-type.h"
#include "icons.h"
#include "config.h"

#define VERSION "lhs/0.1"

#define DEFAULT_ROOT_DIR "/home/httpd/html"
#define DEFAULT_HTTP_PORT 8000
#define DEFAULT_HTTPS_PORT 8001
#define DEFAULT_MAX_SOCKS 50

#ifdef USE_SSL
#include <openssl/ssl.h>
#define DEFAULT_SSL_PROTOCOL SSL2_VERSION
#define DEFAULT_CERT_FILE "lhs.pem"
#endif

#define BACKLOG 5
#define MAX_HEADER_SIZE 1024

#define STATE_NONE 0
#define STATE_HEADER 1
#define STATE_REPLY 2
#define STATE_DATA 3

struct client {
        int state;
        int fd;
        char *buffer;
        int buffer_size;
        int file_fd;
	int directory;
	int size;
        char *filename;
        int timeout;
	char *internal;
#ifdef USE_SSL
	SSL *ssl;
#else
	void *ssl;
#endif
};

#define REPLY_HEADER(x,y,z) \
	"HTTP/1.0 " x " " y "\r\n" \
	"Content-type: text/html\r\n" \
	z \
	"Server: " VERSION "\r\n" \
	"\r\n" \
	"<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n" \
	"<html><head><title>" x " " y "</title></head>\r\n" \
	"<body><h1>" y "</h1>\r\n"
#define REPLY_FOOTER \
	"<hr><address>" VERSION " Server at %s Port %d</address>\r\n" \
	"</body></html>\r\n"

#ifdef USE_IPV6
#define REPLY_ABOUT_IPV6 "<li>IPv6 support\n"
#else
#define REPLY_ABOUT_IPV6
#endif

#ifdef USE_SSL
#define REPLY_ABOUT_SSL "<li>SSLv2/v3 support\n"
#else
#define REPLY_ABOUT_SSL
#endif

#define REPLY_ABOUT \
	"HTTP/1.0 200 OK\r\n" \
	"Content-Type: text/html\r\n" \
	"Server: " VERSION "\r\n" \
	"\r\n" \
	"<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n" \
	"<html><head><title>" VERSION "</title></head>\n" \
	"<body><font size=\"+3\"><b>" VERSION "</b></font><br>\n" \
	"<font size=\"+1\"><b>&copy; Copyright 2001 by <a href=\"mailto:wojtekka@irc.pl\">Wojtek Kaniewski</a></b></font>\n" \
	"<hr>\n" \
	"<i>lhs</i> is a lightweight http server, suitable only for static content. It's single-process, single-threaded and supports a subset of HTTP/1.0, IPv4, IPv6 and SSL. In future, some features like CGI, SSI or PHP may be included.\n" \
	"<p>\n" \
	"Compiled options:\n" \
	"<ul>\n" \
	"<li>IPv4 support\n" \
	REPLY_ABOUT_IPV6 \
	REPLY_ABOUT_SSL \
	"</ul>\n" \
	REPLY_FOOTER
	
#define REPLY_404 \
	\
	REPLY_HEADER("404", "Not found", "") \
	"The requested URL %s was not found on this server.\r\n" \
	REPLY_FOOTER

#define REPLY_403 \
	\
	REPLY_HEADER("403", "Forbidden", "") \
	"You don't have permission to access %s on this server.\r\n" \
	REPLY_FOOTER

#define REPLY_501 \
	\
	REPLY_HEADER("501", "Method Not Implemented", "") \
	"Invalid method in request %s\r\n" \
	REPLY_FOOTER

#define REPLY_301 \
	\
	REPLY_HEADER("301", "Moved Permanently", "Location: %s/\r\n") \
	"The document has moved <A HREF=\"%s/\">here</A>.\r\n" \
	REPLY_FOOTER

#define REPLY_400 \
	\
	REPLY_HEADER("400", "Bad Request", "") \
	"Your browser sent a request that this server could not understand.<P>\r\n" \
	"Invalid URI in request %s\r\n" \
	REPLY_FOOTER
	
#endif __LHS_H
