/*
 *  LDG 2.xx - module de dveloppement
 *	par D.Brziat & O.Landemarre.
 *	(c) 2000 - tous droits rservs.
 *
 *	La routine - complexe - qui permet d'avoir la
 *	liste internes des libraries. Elle intgre toutes les
 *	version de LDG. Elle est utilise par les outils de
 *	maintenance (CPX et showlib) et le manager (la dernire
 *	version de compatibilit).
 */

struct ldg_lib {
	char name[32];		/* nom AES de la lib */
	LDG *ldg;			/* adresse de la LDG */
	short *usedby;     	/* liste des clients */
	short *ndecl;		/* cumul pour dclaration multiple */
};


struct ldg_infos {
	void *listlib;		/* rserv */
	short current;		/* rserv */
	short maxlib;		/* nombre maximale de librairies */
	short maxclient;	/* nombre max de client par lib  */
	short totalclient;	/* nombre total max de client */
	short version;		/* version du gestionnaire */
	short type;			/* type du gestionnaire */
};

#define LDGMGR	1
#define LDGTSR	2

int ldg_mgrlist( struct ldg_infos *infos, short *gl);
int ldg_libslist( struct ldg_infos *infos,  short *gl);
void ldg_initlist( struct ldg_infos *infos);
int ldg_getlib( struct ldg_infos *infos, struct ldg_lib *lib);
int ldg_loadlib( struct ldg_infos *infos);

/* EOF */

