/***************************************************************************
                          hiscore.h  -  description
                             -------------------
    begin                : Wed Mar 1 2000
    copyright            : (C) 2000 by Michael Speck
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HISCORE_H
#define HISCORE_H

/**
  *@author Michael Speck
  */

struct HiScoreEntry {
	char	name[12];
	int		level;
	int     lives;
	int		score;
};


// HiScore is now an interface
class HiScore {
 protected:
  // You cannot directly create a HighScore object. Use
  // CreateXXX instead.
  HiScore() {};
public: 
  // returns a pointer to a new high score table
  // (the vanilla kind, only scores)
  static HiScore* CreateStandard(char* fileName);
  static HiScore* CreateComposite(char* fileName);
  static HiScore* CreateLevel(char* fileName);

	virtual ~HiScore();
	virtual int Load(char *f) = 0;
	virtual void Save(char *f) = 0;
	// saves back to the file it was loaded from
	virtual void Save() = 0;
	virtual int GetTableCount() { return 1; };     
	// table in [0..GetTableCount()-1]
	virtual HiScoreEntry Entry(int line, int table=0) = 0;
	virtual int CheckEntry(HiScoreEntry *entry) = 0;
};


// Standard, ordered by score
class StandardHiScore : public HiScore {
 protected:
	HiScoreEntry	*entries;
	int				entry_num;
	char			filename[32];
 public:
  StandardHiScore(char* f);
  StandardHiScore(FILE* f);
  virtual ~StandardHiScore();
	virtual void Create();
	virtual int Load(char *f);
	virtual void Save(char *f);
	// saves back to the file it was loaded from
	virtual void Save();
	virtual HiScoreEntry Entry(int line, int table=0);
	virtual int CheckEntry(HiScoreEntry *entry) ;

	virtual int Load(FILE* file);
	virtual void Save(FILE* file);
};

// this time we order by level
class LevelHiScore: public StandardHiScore {
 public:
  LevelHiScore(char* f) : StandardHiScore(f) {};
  LevelHiScore(FILE* f) : StandardHiScore(f) {};
  virtual int CheckEntry(HiScoreEntry *entry);
};

// maintains two tables: one per score, the other per level
class CompositeHiScore : public HiScore {
 private:
   char filename[32];
   LevelHiScore* pLevel;
   StandardHiScore* pStandard;

 public:
   CompositeHiScore(char* f);
   virtual ~CompositeHiScore();

   virtual HiScoreEntry Entry(int line, int table=0);
   virtual int CheckEntry(HiScoreEntry *entry) ;
   virtual void Save();   

   virtual int Load(char *f);
   virtual void Save(char *f);
};

#endif
