/*	$Id: utils.h,v 1.1 2005/04/19 15:12:24 itohy Exp $	*/

/*
 * Copyright (c) 2005 ITOH Yasufumi.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form is unlimited.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

struct progress {
	uint32_t maxcnt;
	int maxbar, curbar;
	int maxnumlen;
	int active;
};

void progress_init __P((struct progress *, uint32_t /*max*/, const char *));
void progress_setval __P((struct progress *, uint32_t /*val*/));
void progress_end __P((struct progress *));

struct vararray {
	size_t itemsize;
	size_t allocsize;
	size_t nitem;
	void (*dtor)__P((void *));	/* destructor of an item */
	void *buf;
};

void vararray_init __P((struct vararray *, size_t, void (*)(void *)));
void vararray_removeall __P((struct vararray *));
void *vararray_item __P((struct vararray *, int));
void *vararray_last __P((struct vararray *));
int vararray_add __P((struct vararray *, void *));
void vararray_qsort __P((struct vararray *,
	int (*)(const void *, const void *)));

struct varbuf {
	size_t size;
	size_t allocsize;
	void *buf;
};

void varbuf_init __P((struct varbuf *));
void varbuf_reinit __P((struct varbuf *));
int varbuf_add __P((struct varbuf *, void *, size_t));
void *varbuf_getbuf __P((struct varbuf *, size_t *));

void *stash __P((const void *));
void *stash2 __P((const void *, size_t));
void freestash __P((void *));
