/*
 * test.c
 *
 * Copyright (C) 2009-2010, ivan demakov.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 * Author:        ivan demakov <ksion@users.sourceforge.net>
 * Creation date: Sun Mar 22 16:18:42 2009
 *
 */

#include "ksi_printf.h"
#include "ksi_type.h"
#include "ksi_comp.h"
#include "ksi_int.h"

#include <stdio.h>


int
main(int argc, char *argv[])
{
  ksi_obj x;

  printf("libdir=%s\n", ksi_scheme_lib_dir());

  ksi_init(&x);
  ksi_init_std_ports (0, 1, 2);

  x = ksi_nil;
  x = ksi_cons(ksi_long2num(999), x);
  x = ksi_cons(ksi_double2num(1.2345), x);
  x = ksi_cons(ksi_make_vector(ksi_long2num(2), ksi_long2num(2)), x);
  x = ksi_cons(ksi_str02sym("hehe"), x);
  x = KSI_LIST2(x, ksi_str02sym("xxx"));

  char *msg = ksi_aprintf("obj=%s", ksi_obj2str(x));
  printf("%s\n", msg);

  ksi_env base_env = ksi_get_lib_env("ksi", "base", 0);
  ksi_env io_env = ksi_get_lib_env("ksi", "io", "base", 0);
  x = ksi_eval_str_with_catch("(let loop ((a (list 1 2 3))) (if (pair? a) (begin (display (car a)) (loop (cdr a))) (newline)))", base_env);
  printf("res=%s\n", ksi_obj2str(x));

  ksi_env env = ksi_top_level_env();
  ksi_import(base_env, ksi_str02sym("list"), env, 0);
  ksi_import(base_env, ksi_str02sym("pair?"), env, 0);
  ksi_import(base_env, ksi_str02sym("car"), env, 0);
  ksi_import(base_env, ksi_str02sym("cdr"), env, 0);
  ksi_import(io_env, ksi_str02sym("display"), env, 0);
  ksi_import(io_env, ksi_str02sym("newline"), env, 0);

  x = ksi_eval_str_with_catch("(let loop ((a (list 7 8 9))) (if (pair? a) (begin (display (car a)) (loop (cdr a))) (newline)))", env);
  printf("res=%s\n", ksi_obj2str(x));

  ksi_term();
  return 0;
}

 /* End of code */
