/***************************************************************************
	sprites.h - sprite routines - header

    begin                : 29 Mar 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

// Sprite names - this list must be kept in sync with spriteData in spritesData.c
enum SPR_Names
{
	// No sprite
	SPR_None,

	// Interface
	SPR_CompanyLogo,
	SPR_Title,

	// Blocks
	SPR_MainCharIdle,
	SPR_MainCharMoveIn,
	SPR_MainCharMoveOut,
	SPR_MainCharTeleport,
	SPR_MainCharInTeleport,
	SPR_MainCharExit,
	SPR_Blank,
	SPR_StandardIdle,
	SPR_StandardMoveIn,
	SPR_StandardMoveOut,
	SPR_StuckIdle,
	SPR_TeleportIdle,
	SPR_Exit,

	// Bg Objects
	SPR_InterfaceBackIdle,
	SPR_InterfaceBackDisabled,
	SPR_InterfaceBackLit,
	SPR_InterfaceBackIn,
	SPR_InterfaceForwardIdle,
	SPR_InterfaceForwardDisabled,
	SPR_InterfaceForwardLit,
	SPR_InterfaceForwardIn,
	SPR_InterfaceBeginIdle,
	SPR_InterfaceBeginDisabled,
	SPR_InterfaceBeginLit,
	SPR_InterfaceBeginIn,
	SPR_InterfaceEndIdle,
	SPR_InterfaceEndDisabled,
	SPR_InterfaceEndLit,
	SPR_InterfaceEndIn,
//	-----------------------------------------
	noOfSprites
};

// Sprite structure
typedef struct
{
	enum SPR_Names	name;			// Name from enum SPR_Names in sprites.h
	SDL_Surface		*surface;		// Pointer to the SDL_Surface bitmap
	float			xOffset;		// Final position's x offset from top left corner
	float			yOffset;		// Final position's y offset from top left corner
	int				width;			// width of 1 frame
	int				height;			// height of 1 frame
	Uint32			totalFrames;	// Total frames in the animation
	Uint32			frameRate;		// How long each frame should last
	Uint32			noOfDirs;		// How many directions the sprite has
} SPR_Sprite;

SPR_Sprite sprites[noOfSprites];

// ---------------------------------------------------------------------------------------------------------------------
// Macros
// ---------------------------------------------------------------------------------------------------------------------

// Checks whether a sprite's data has been loaded into memory
#define SPR_IsSpriteLoaded(_sprite) \
	(_sprite->surface != NULL)

// ---------------------------------------------------------------------------------------------------------------------
// Functions
// ---------------------------------------------------------------------------------------------------------------------

// Resets all the sprite structures
void SPR_Init(void);

// Loads a bitmap from the speciified filename and converts it to SDL-optimized format.
SDL_Surface* SPR_LoadConvert(const char *_fileName, Uint8 _alpha);

// Loads a sprite into memory
void SPR_LoadSprite(SPR_Sprite *_sprite);

// Attempts to reinvent what SDL_BlitSurface does and has wild dreams of actually being faster
// Note : _x and _y are treated as absolute screen coordinates
void SPR_BlitSprite(SPR_Sprite *_sprite, int _x, int _y, Uint32 _dir, Uint32 _frame);

