/***************************************************************************
	objectDefs.c - object definitions and default values

    begin                : 09 Sep 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

// Object names
enum OBJ_Names
{
	// Interface Objects
	OBJ_Interface,

	// Blocks
	OBJ_MainChar,
	OBJ_Blank,
	OBJ_Standard,
	OBJ_Stuck,
	OBJ_Teleport,
	OBJ_Exit,

	// Bg Objects
	OBJ_InterfaceBack,
	OBJ_InterfaceForward,
	OBJ_InterfaceBegin,
	OBJ_InterfaceEnd,
// ---------------------------
	OBJ_NO_OF_OBJECTS
};

// Some definitions from the object names
#define OBJ_MAINCHARID		OBJ_MainChar

// Object types
enum OBJ_Types
{
	OBT_Interface,
	OBT_Block,
	OBT_BgObject,
	// ----------------------
  	OBT_NO_OF_TYPES
};

// --------------------------- Object states ------------------------------
// Interface Objects
enum InterfaceStates
{
	OBJS_InterfaceCompanyLogo,
	OBJS_InterfaceTitle,
};

// Blocks
enum MainCharStates
{
	OBJS_MainCharMoveIn,
	OBJS_MainCharPause,
	OBJS_MainCharInPlay,
	OBJS_MainCharWaitingForBlank,
	OBJS_MainCharMoveOut,
	OBJS_MainCharTeleportIn,
	OBJS_MainCharTeleportOut,
	OBJS_MainCharInTeleport,
	OBJS_MainCharInTeleportWaitingForBlank,
	OBJS_MainCharMoveOutOfTeleport,
	OBJS_MainCharExiting,
};

enum BlankStates
{
	OBJS_BlankIdle,
};

enum StandardStates
{
	OBJS_StandardIdle,
	OBJS_StandardMoveIn,
	OBJS_StandardPause,
	OBJS_StandardMoveOut,
};

enum StuckStates
{
	OBJS_StuckIdle,
};

enum TeleportStates
{
	OBJS_TeleportIdle,
};

enum ExitStates
{
	OBJS_ExitIdle,
};

// Bg Objects
enum InterfaceButtonStates
{
	OBJS_InterfaceButtonIdle,
	OBJS_InterfaceButtonPressed,
	OBJS_InterfaceButtonDepressed,
	OBJS_InterfaceButtonDisabled,
};

// ---------------------------------- Various object defaults --------------------------------------

typedef struct
{
	enum OBJ_Types		objType;			// OBT_... from OBJ_Types above
	int					initialState;		// OBJS_... from enums above; state the object starts in
	enum SPR_Names		defaultSprite;		// SPR_... from SPR_Names in sprites.h - initial sprite
	enum OBJ_AnimTypes	animType;			// OBA_... from OBJ_AnimTypes in objects.c - starting anim type
} OBJ_DefaultsStruct;

OBJ_DefaultsStruct OBJ_Defaults[OBJ_NO_OF_OBJECTS] =
{
	// Interface Objects
	{	// OBJ_Interface
		OBT_Interface,					// objType
		OBJS_InterfaceCompanyLogo,		// initialState
		SPR_CompanyLogo,				// defaultSprite
		OBA_Frozen,						// animType
	},

	// Blocks
	{	// OBJ_MainChar
		OBT_Block,						// objType
		OBJS_MainCharInPlay,			// initialState
		SPR_MainCharIdle,				// defaultSprite
		OBA_Frozen,						// animType
	},
	{	// OBJ_Blank
		OBT_Block,						// objType
		OBJS_BlankIdle,					// initialState
		SPR_Blank,						// defaultSprite
		OBA_Frozen,						// animType
	},
	{	// OBJ_Standard
		OBT_Block,						// objType
		OBJS_StandardIdle,				// initialState
		SPR_StandardIdle,				// defaultSprite
		OBA_Frozen,						// animType
	},
	{	// OBJ_Stuck
		OBT_Block,						// objType
		OBJS_StuckIdle,					// initialState
		SPR_StuckIdle,					// defaultSprite
		OBA_Frozen,						// animType
	},
	{	// OBJ_Teleport
		OBT_Block,						// objType
		OBJS_TeleportIdle,				// initialState
		SPR_TeleportIdle,				// defaultSprite
		OBA_Frozen,						// animType
	},
	{	// OBJ_Exit
		OBT_Block,						// objType
		OBJS_ExitIdle,					// initialState
		SPR_Exit,						// defaultSprite
		OBA_Frozen,						// animType
	},

	// Bg Objects
	{	// OBJ_InterfaceBack
		OBT_BgObject,					// objType
		OBJS_InterfaceButtonIdle,		// initialState
		SPR_InterfaceBackIdle,			// defaultSprite
		OBA_Frozen,						// animType
	},
	{	// OBJ_InterfaceForward
		OBT_BgObject,					// objType
		OBJS_InterfaceButtonIdle,		// initialState
		SPR_InterfaceForwardIdle,		// defaultSprite
		OBA_Frozen,						// animType
	},
	{	// OBJ_InterfaceBegin
		OBT_BgObject,					// objType
		OBJS_InterfaceButtonIdle,		// initialState
		SPR_InterfaceBeginIdle,			// defaultSprite
		OBA_Frozen,						// animType
	},
	{	// OBJ_InterfaceEnd
		OBT_BgObject,					// objType
		OBJS_InterfaceButtonIdle,		// initialState
		SPR_InterfaceEndIdle,			// defaultSprite
		OBA_Frozen,						// animType
	},
};
