/***************************************************************************
	input.h - keyboard/joystick/etc routines - header

    begin                : 28 Apr 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

// -------------------------------------------------------------------------------------------------
// Constants
// -------------------------------------------------------------------------------------------------

enum IN_MBStates
{
	IN_MB_UP,			// Not pressed
	IN_MB_CLICKED,		// Just pressed this frame
	IN_MB_HELD,			// Still pressed since last frame
};

// -------------------------------------------------------------------------------------------------
// Global Variables
// -------------------------------------------------------------------------------------------------

extern SDL_Event			IN_Event;
extern SDL_Joystick			*joystick;
extern bool					IN_Up;
extern bool					IN_Down;
extern bool					IN_Left;
extern bool					IN_Right;
extern bool					gamePaused;
extern vec2di				IN_MousePos;
extern enum IN_MBStates		IN_MouseButtonState;

// -------------------------------------------------------------------------------------------------
// Functions
// -------------------------------------------------------------------------------------------------

// Resets input variables
void IN_Reset();

// Initialises input
void IN_Init(void);

// Processes any SDL input and updates the global variables accordingly
void IN_ProcessInput(void);
