/***************************************************************************
	backgroundsData.h - Information for all the backgrounds' data

    begin                : 22 Feb 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

// Structure for a layer
typedef struct
{
	char	fileName[50];
	Uint8	alpha;
	float	relSpeedX;
	float	relSpeedY;
	bool	visible;
} layerStruct;

// Structure for a main layer's info
typedef struct
{
	uint	layerNo;		// Layer no of the main layer
	float	speedX;			// Main layer's absolute X speed (in pixels/second)
	float	speedY;			// Main layer's absolute X speed (in pixels/second)
	int		startX;			// Starting X coordinate
	int		startY;			// Starting Y coordinate
} mainLayerStruct;

// Bg files for the interface (Level 20 is treated as the interface)
const layerStruct interfaceLayers[] =
{
//	{filename,					Alpha		relSpeedX,	relSpeedY	visible
	{"interface/title_bg.png",	255,		0.0,		0.0,		true},			// interface, layer 0
};

// Bg files for levels not yet in the game
const layerStruct levelDummyLayers[] =
{
//	{filename,					Alpha		relSpeedX,	relSpeedY	visible
	{"levelDummy/layer0.png",	255,		0.0,		0.0,		true},			// Dummy level, layer 0
};

// Bg files corresponding to level 0
const layerStruct level0Layers[] =
{
//	{filename,					Alpha		relSpeedX,	relSpeedY	visible
	{"level0/bg.png",			255,		0.0,		0.5,		true},			// level 0, layer 0
};


// No of layers in each level
const int levelTotalLayers[] =
{
	sizeof(interfaceLayers)/sizeof(layerStruct),	// 0
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 1
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 2
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 3
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 4
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 5
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 6
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 7
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 8
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 9
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 10
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 11
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 12
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 13
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 14
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 15
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 16
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 17
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 18
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 19
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 20
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 21
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 22
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 23
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 24
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 25
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 26
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 27
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 28
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 29
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 30
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 31
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 32
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 33
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 34
	sizeof(levelDummyLayers)/sizeof(layerStruct),	// 35
};

// List of level array pointers
const layerStruct *levelLayerList[] =
{
	(layerStruct*) interfaceLayers,		// 0
	(layerStruct*) levelDummyLayers,	// 1,
	(layerStruct*) levelDummyLayers,	// 2,
	(layerStruct*) levelDummyLayers,	// 3,
	(layerStruct*) levelDummyLayers,	// 4,
	(layerStruct*) levelDummyLayers,	// 5,
	(layerStruct*) levelDummyLayers,	// 6,
	(layerStruct*) levelDummyLayers,	// 7,
	(layerStruct*) levelDummyLayers,	// 8,
	(layerStruct*) levelDummyLayers,	// 9,
	(layerStruct*) levelDummyLayers,	// 10,
	(layerStruct*) levelDummyLayers,	// 11,
	(layerStruct*) levelDummyLayers,	// 12,
	(layerStruct*) levelDummyLayers,	// 13,
	(layerStruct*) levelDummyLayers,	// 14,
	(layerStruct*) levelDummyLayers,	// 15,
	(layerStruct*) levelDummyLayers,	// 16,
	(layerStruct*) levelDummyLayers,	// 17,
	(layerStruct*) levelDummyLayers,	// 18,
	(layerStruct*) levelDummyLayers,	// 19,
	(layerStruct*) levelDummyLayers,	// 20,
	(layerStruct*) levelDummyLayers,	// 21,
	(layerStruct*) levelDummyLayers,	// 22,
	(layerStruct*) levelDummyLayers,	// 23,
	(layerStruct*) levelDummyLayers,	// 24,
	(layerStruct*) levelDummyLayers,	// 25,
	(layerStruct*) levelDummyLayers,	// 26,
	(layerStruct*) levelDummyLayers,	// 27,
	(layerStruct*) levelDummyLayers,	// 28,
	(layerStruct*) levelDummyLayers,	// 29,
	(layerStruct*) levelDummyLayers,	// 30,
	(layerStruct*) levelDummyLayers,	// 31,
	(layerStruct*) levelDummyLayers,	// 32,
	(layerStruct*) levelDummyLayers,	// 33,
	(layerStruct*) levelDummyLayers,	// 34,
	(layerStruct*) levelDummyLayers,	// 35,
};

// Values for the main layer in each level
const mainLayerStruct mainLayers[] =
{
//	{layerNo	speedX	speedY	startX	startY}
	{0,			0.0,	0.0,	0,		0},				// interface
	{0,			0.0,	0.0,	0,		0},				// 1
	{0,			0.0,	0.0,	0,		0},				// 2
	{0,			0.0,	0.0,	0,		0},				// 3
	{0,			0.0,	0.0,	0,		0},				// 4
	{0,			0.0,	0.0,	0,		0},				// 5
	{0,			0.0,	0.0,	0,		0},				// 6
	{0,			0.0,	0.0,	0,		0},				// 7
	{0,			0.0,	0.0,	0,		0},				// 8
	{0,			0.0,	0.0,	0,		0},				// 9
	{0,			0.0,	0.0,	0,		0},				// 10
	{0,			0.0,	0.0,	0,		0},				// 11
	{0,			0.0,	0.0,	0,		0},				// 12
	{0,			0.0,	0.0,	0,		0},				// 13
	{0,			0.0,	0.0,	0,		0},				// 14
	{0,			0.0,	0.0,	0,		0},				// 15
	{0,			0.0,	0.0,	0,		0},				// 16
	{0,			0.0,	0.0,	0,		0},				// 17
	{0,			0.0,	0.0,	0,		0},				// 18
	{0,			0.0,	0.0,	0,		0},				// 19
	{0,			0.0,	0.0,	0,		0},				// 20
	{0,			0.0,	0.0,	0,		0},				// 21
	{0,			0.0,	0.0,	0,		0},				// 22
	{0,			0.0,	0.0,	0,		0},				// 23
	{0,			0.0,	0.0,	0,		0},				// 24
	{0,			0.0,	0.0,	0,		0},				// 25
	{0,			0.0,	0.0,	0,		0},				// 26
	{0,			0.0,	0.0,	0,		0},				// 27
	{0,			0.0,	0.0,	0,		0},				// 28
	{0,			0.0,	0.0,	0,		0},				// 29
	{0,			0.0,	0.0,	0,		0},				// 30
	{0,			0.0,	0.0,	0,		0},				// 31
	{0,			0.0,	0.0,	0,		0},				// 32
	{0,			0.0,	0.0,	0,		0},				// 33
	{0,			0.0,	0.0,	0,		0},				// 34
	{0,			0.0,	0.0,	0,		0},				// 35
};

// How many levels are in the game
#define NO_OF_LEVELS sizeof(levelLayerList)/sizeof(layerStruct*)
