/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MONITOR_QUEUE_H
#define __MONITOR_QUEUE_H

#include "SDL.h"
#include <queue>
#include <assert.h>

using namespace std;

#define sem_initial_value 1

// HUOM! tm luokka pitisi muuttaa enemmn supplier-producer -tyyliseksi,
// eli asettaa condition variablet!

/// Definitions
template <class T>
class monitor_queue
{
protected:
  SDL_sem *sem;
  queue<T> q;

public:
  monitor_queue();
  ~monitor_queue();
  void push (const T& t);
  T pop();
  bool empty() const;
};

/// Implementations
template <class T>
monitor_queue<T>::monitor_queue()
{
  sem = SDL_CreateSemaphore (sem_initial_value);
  if (sem == NULL)
	{
	  fprintf (stderr, "Error creating semaphore: %s\n", SDL_GetError());
	  exit(2);
	}
}

template <class T>
void monitor_queue<T>::push(const T& t)
{
  // wait on the semaphore
  SDL_SemWait (sem);

  // printf ("before push %d %d %d\n", t->type, t->owner, t->param1);   
   q.push(t);
  //T k = q.front();
  //k = q.front();
  //printf ("after push %d %d %d\n", k->type, k->owner, k->param1); 

  SDL_SemPost(sem);
}

template <class T>
T monitor_queue<T>::pop()
{
  // wait on the semaphore
  SDL_SemWait (sem);

  // PRECONDITION VIOLATION
  if (q.empty())
	assert(0);

  T t = q.front();
  q.pop();

  SDL_SemPost (sem);

  return t;
}

template <class T>
bool monitor_queue<T>::empty() const
{
  return q.empty();
}

template <class T>
monitor_queue<T>::~monitor_queue()
{
  SDL_DestroySemaphore (sem);
}

#endif
