/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "SDL.h"
#include "SDL_net.h"
#include "SDL_ttf.h"
#include <stdlib.h>
#include <stdio.h>
#include "msg.h"
#include "terrain.h"
#include "game_client.h"
#include "gui_screens.h"
#include "globals.h"
#include "gfx.h"
#include "SDL_mixer.h"
#include "config.h"

#define MAX_HOSTLEN 1024
#define FONTNAME "Vera.ttf"

#define REAL_HEIGHT 480

using namespace std;

game_client *client = NULL;

void print_usage()
{
  printf ("Usage: kajaani-kombat [-fs]\n");
}

void print_license()
{
  printf ("Kajaani Kombat %s %s\n", VERSION, COPYRIGHT);
}
int main (int argc, char ** argv) 
{
  SDL_Surface *screen;
  TTF_Font *font;
  
  char window_text[100];
  sprintf(window_text,"Kajaani Kombat %s", VERSION);

  print_license();

  if (argc > 2)
    {
      print_usage();
      exit(0);
    }

  if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_TIMER) != 0)
    {
      fprintf (stderr, "Error initializing SDL\n");
      exit(1);
    }
  atexit(SDL_Quit);

  file_config    *cfg = new file_config();

  int flags = SDL_HWSURFACE | SDL_SRCALPHA | SDL_DOUBLEBUF;
  if (argc == 2)
    {
      if (strcmp(argv[1], "-fs") == 0)
	flags |= SDL_FULLSCREEN;
      else
	{
	  print_usage();
	  exit(0);
	}
    }
    
  screen = SDL_SetVideoMode (SCR_WIDTH, REAL_HEIGHT, 32, flags);
  if (screen == NULL)
    {
      fprintf (stderr, "Error setting up screen\n");
      exit(1);
    }

  //set window text
  SDL_WM_SetCaption(window_text, NULL);

  //prepare for null or real audio
  audio *aud;

  // init sdl-mixer
  if (Mix_OpenAudio (MIX_DEFAULT_FREQUENCY, MIX_DEFAULT_FORMAT, 2, 1024) == -1)
    {
      fprintf (stderr, "Error opening audio: %s\n", Mix_GetError());
      fprintf (stderr, "Using null audio.\n");
      aud = new nullaudio();
      //exit(1);
    }
  else
    {
      try {
	aud = new realaudio();
      }
      catch (string &s)
	{
	  fprintf (stderr, "Error creating realaudio object: %s\n", s.c_str());
	  fprintf (stderr, "Using null audio.\n");
	  aud = new nullaudio();
	}
    }

  
  //not needed anymore YES IT IS NEEDED! do not remove -tommi
  // clean sdlmixer on exit
  atexit(Mix_CloseAudio);  

  // init sdl-net
  if (SDLNet_Init () < 0) {
	fprintf (stderr, "SDLNet init failed: %s\n", SDLNet_GetError());
	exit (1);
  }

  // clean sdlnet on exit
  atexit (SDLNet_Quit);

  
  // init ttf
  if (TTF_Init() == -1)
    {
      fprintf (stderr, "Error starting libttf\n");
      exit(1);
    }

  font = font_load(FONTNAME, 12);
  if (font == NULL)
    {
      fprintf (stderr, "Error loading font %s\n", FONTNAME);
      exit(1);
    }

  // hide cursor!
  SDL_ShowCursor (SDL_DISABLE);

  SDL_EnableKeyRepeat (100, 100);

  // init gfx
  gfx *g = new gfx(screen, font);
  starfield_efect *se = new starfield_efect(coord::pc(SCR_WIDTH >> 1, SCR_HEIGHT >> 1), coord::pc(SCR_WIDTH, SCR_HEIGHT));
  for (int i=0;i<10;i++)
    se->move(100);



  // init main screen.
  main_screen *main_scr = new main_screen (screen, font, g, se, aud, cfg);
  main_scr->activate(0);
  delete main_scr;

  TTF_CloseFont(font);

  delete aud;
  delete g;
  delete se;
  delete cfg;

  return 0;
}

