/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StandbyContextImpl;
import org.apache.kafka.streams.processor.internals.StateDirectory;

public class StandbyTask
extends AbstractTask {
    private Map<TopicPartition, Long> checkpointedOffsets = new HashMap<TopicPartition, Long>();

    StandbyTask(TaskId id, Collection<TopicPartition> partitions, ProcessorTopology topology, Consumer<byte[], byte[]> consumer, ChangelogReader changelogReader, StreamsConfig config, StreamsMetrics metrics, StateDirectory stateDirectory) {
        super(id, partitions, topology, consumer, changelogReader, true, stateDirectory, config);
        this.processorContext = new StandbyContextImpl(id, config, this.stateMgr, metrics);
    }

    @Override
    public boolean initializeStateStores() {
        this.log.trace("Initializing state stores");
        this.registerStateStores();
        this.checkpointedOffsets = Collections.unmodifiableMap(this.stateMgr.checkpointed());
        this.processorContext.initialized();
        this.taskInitialized = true;
        return true;
    }

    @Override
    public void initializeTopology() {
    }

    @Override
    public void resume() {
        this.log.debug("Resuming");
        this.updateOffsetLimits();
    }

    @Override
    public void commit() {
        this.log.trace("Committing");
        this.flushAndCheckpointState();
        this.updateOffsetLimits();
    }

    @Override
    public void suspend() {
        this.log.debug("Suspending");
        this.flushAndCheckpointState();
    }

    private void flushAndCheckpointState() {
        this.stateMgr.flush();
        this.stateMgr.checkpoint(Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean clean, boolean isZombie) {
        if (!this.taskInitialized) {
            return;
        }
        this.log.debug("Closing");
        boolean committedSuccessfully = false;
        try {
            if (clean) {
                this.commit();
                committedSuccessfully = true;
            }
        }
        finally {
            this.closeStateManager(committedSuccessfully);
        }
    }

    @Override
    public void closeSuspended(boolean clean, boolean isZombie, RuntimeException e) {
        this.close(clean, isZombie);
    }

    public List<ConsumerRecord<byte[], byte[]>> update(TopicPartition partition, List<ConsumerRecord<byte[], byte[]>> records) {
        this.log.trace("Updating standby replicas of its state store for partition [{}]", (Object)partition);
        return this.stateMgr.updateStandbyStates(partition, records);
    }

    public Map<TopicPartition, Long> checkpointedOffsets() {
        return this.checkpointedOffsets;
    }
}

