#!/usr/bin/env python
#
# Distutils installation script for Jools
#
from distutils.core import setup
import os, string, sys



# Read off the PREFIX value, so we can tell jools where to find its
# data files (FIXME: is there a clean way to handle this through distutils?
if 'sdist' not in sys.argv and 'clean' not in sys.argv:
   PREFIX=os.path.normpath(sys.prefix)  # default
   for arg in sys.argv:
      index = string.find(arg, "--prefix=")
      if index > -1:
         PREFIX = os.path.normpath(arg[(index+len("--prefix=")):])

   ROOT = "/"  # default
   for arg in sys.argv:
      index = string.find(arg, "--root=")
      if index > -1:
         ROOT = os.path.normpath(arg[(index+len("--root=")):])

   config = open("jools/config.py", "w")
   config.write("MEDIAROOT = \"" + os.path.join(PREFIX,"share/jools") + "\"\n")
   config.close()


# Append "dirname" and its datafiles to the list of files to install.
# This is called once per directory via os.path.walk().
def appendDataFiles(installList, dirname, files):
   newFiles = []
   for file in files:
      fullFile = os.path.join(dirname, file)
      if os.path.isfile(fullFile):
         newFiles.append(fullFile)
   installList.append( (os.path.join('share', dirname), newFiles) )


# Get all data files by walking through the proper directory trees
# and calling 'appendDataFiles'.
def getDataFilesList():
   installList = []
   # images
   os.path.walk('jools/images', appendDataFiles, installList)
   # sounds
   os.path.walk('jools/sounds', appendDataFiles, installList)
   # music
   os.path.walk('jools/music', appendDataFiles, installList)
   # fonts
   os.path.walk('jools/fonts', appendDataFiles, installList)
   return installList


# Run the distutils setup.
setup(name = "jools",
   version = "0.20",
   description = "graphical pattern-matching game",
   author = "Paul J. Pelzl",
   author_email = "pelzlpj@eecs.umich.edu",
   maintainer = "Paul J. Pelzl",
   maintainer_email = "pelzlpj@eecs.umich.edu", 
   url = "http://www.eecs.umich.edu/~pelzlpj/jools", 
   licence = "GNU General Public License",
   platforms = "*nix/X11, OS X",
   keywords = "jewel bejeweled tetris pygame puzzle",
   long_description = ( 
      "Jools is a clone of Bejeweled, a popular pattern-matching game in\n" +
      "the tradition of Tetris.  Swap the positions of adjacent jools\n" +
      "to match three or more in a row; as they disappear, new jools\n" +
      "fill their places.  Jools is written using pygame, and features\n" +
      "3D rendered graphics." ),
   packages = [ 'jools' ],            # install all the .py files 
   scripts  = [ 'jools/jools' ],      # install the executable script
   data_files = getDataFilesList()    # install the game media and documentation
)


# Reset 'config.py' for the source distribution.
config = open("jools/config.py", "w")
config.write("MEDIAROOT = \"\"\n")
config.close()


