/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.office;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.Helper;
import com.sun.jna.platform.win32.COM.office.MSExcel;
import com.sun.jna.platform.win32.COM.office.MSWord;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinDef;
import java.io.File;
import java.io.IOException;

public class MSOfficeDemo {
    public static void main(String[] args) throws IOException {
        Ole32.INSTANCE.CoInitializeEx(Pointer.NULL, 0);
        try {
            MSOfficeDemo demo = new MSOfficeDemo();
            demo.testMSExcel();
            demo.testMSWord();
        }
        finally {
            Ole32.INSTANCE.CoUninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMSWord() throws IOException {
        File demoDocument = null;
        MSWord msWord = null;
        WinDef.LONG wdFormatPDF = new WinDef.LONG(17L);
        WinDef.LONG wdFormatRTF = new WinDef.LONG(6L);
        WinDef.LONG wdFormatHTML = new WinDef.LONG(8L);
        WinDef.LONG wdFormatDocument = new WinDef.LONG(0L);
        WinDef.LONG wdFormatDocumentDefault = new WinDef.LONG(16L);
        WinDef.LONG wdOriginalDocumentFormat = new WinDef.LONG(1L);
        WinDef.LONG wdPromptUser = new WinDef.LONG(2L);
        WinDef.LONG wdWordDocument = new WinDef.LONG(0L);
        try {
            msWord = new MSWord();
            System.out.println("MSWord version: " + msWord.getVersion());
            msWord.setVisible(true);
            Helper.sleep(5);
            demoDocument = Helper.createNotExistingFile("jnatest", ".doc");
            Helper.extractClasspathFileToReal("/com/sun/jna/platform/win32/COM/util/office/resources/jnatest.doc", demoDocument);
            msWord.openDocument(demoDocument.getAbsolutePath());
            msWord.insertText("Hello from JNA! \n\n");
            Helper.sleep(10);
            System.out.println("Wrinting files to: " + Helper.tempDir);
            msWord.SaveAs(new File(Helper.tempDir, "jnatestSaveAs.doc").getAbsolutePath(), wdFormatDocument);
            msWord.SaveAs(new File(Helper.tempDir, "jnatestSaveAs.pdf").getAbsolutePath(), wdFormatPDF);
            msWord.SaveAs(new File(Helper.tempDir, "jnatestSaveAs.rtf").getAbsolutePath(), wdFormatRTF);
            msWord.SaveAs(new File(Helper.tempDir, "jnatestSaveAs.html").getAbsolutePath(), wdFormatHTML);
            msWord.closeActiveDocument(false);
            msWord.newDocument();
            msWord.insertText("Hello from JNA! \n Please notice that JNA can control MS Word via the new COM interface! \nHere we are creating a new word document and we save it to the 'TEMP' directory!");
            msWord.SaveAs(new File(Helper.tempDir, "jnatestNewDoc1.docx").getAbsolutePath(), wdFormatDocumentDefault);
            msWord.SaveAs(new File(Helper.tempDir, "jnatestNewDoc2.docx").getAbsolutePath(), wdFormatDocumentDefault);
            msWord.SaveAs(new File(Helper.tempDir, "jnatestNewDoc3.docx").getAbsolutePath(), wdFormatDocumentDefault);
            msWord.closeActiveDocument(false);
            msWord.openDocument(new File(Helper.tempDir, "jnatestNewDoc1.docx").getAbsolutePath());
            msWord.insertText("Hello some changes from JNA!\n");
            msWord.openDocument(new File(Helper.tempDir, "jnatestNewDoc2.docx").getAbsolutePath());
            msWord.insertText("Hello some changes from JNA!\n");
            msWord.openDocument(new File(Helper.tempDir, "jnatestNewDoc3.docx").getAbsolutePath());
            msWord.insertText("Hello some changes from JNA!\n");
            msWord.Save(false, wdPromptUser);
        }
        catch (COMException e) {
            if (e.getExcepInfo() != null) {
                System.out.println("bstrSource: " + e.getExcepInfo().bstrSource);
                System.out.println("bstrDescription: " + e.getExcepInfo().bstrDescription);
            }
        }
        finally {
            if (msWord != null) {
                msWord.quit();
            }
            if (demoDocument != null && demoDocument.exists()) {
                demoDocument.delete();
            }
        }
    }

    public void testMSExcel() throws IOException {
        File demoDocument = null;
        MSExcel msExcel = null;
        try {
            msExcel = new MSExcel();
            System.out.println("MSExcel version: " + msExcel.getVersion());
            msExcel.setVisible(true);
            Helper.sleep(5);
            demoDocument = Helper.createNotExistingFile("jnatest", ".xls");
            Helper.extractClasspathFileToReal("/com/sun/jna/platform/win32/COM/util/office/resources/jnatest.xls", demoDocument);
            msExcel.openExcelBook(demoDocument.getAbsolutePath());
            msExcel.insertValue("A1", "Hello from JNA!");
            Helper.sleep(10);
            msExcel.closeActiveWorkbook(true);
            msExcel.newExcelBook();
            msExcel.insertValue("A1", "Hello from JNA!");
            msExcel.closeActiveWorkbook(true);
        }
        finally {
            if (msExcel != null) {
                msExcel.quit();
            }
            if (demoDocument != null && demoDocument.exists()) {
                demoDocument.delete();
            }
        }
    }
}

