/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.util;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.util.FileUtils;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.cfg.Percentage;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.ColumnFormat;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.reporters.util.HistoricalSupport;
import com.cenqua.clover.reporters.util.MetricsDiffSummary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;

public class HistoricalReportDescriptor {
    private final Logger log = Logger.getInstance();
    private Historical histCfg;
    private SortedMap models;
    private List moversDescriptors;
    private List addedDescriptors;
    private HasMetrics subjectMetrics;
    private Long firstTS;
    private Long lastTS;
    private boolean enoughForMovers;

    public HistoricalReportDescriptor(CloverReportConfig cfg) throws CloverException, IOException {
        this.histCfg = (Historical)cfg;
        if (this.histCfg == null) {
            throw new CloverException("Invalid report config");
        }
        this.moversDescriptors = new ArrayList(this.histCfg.getMovers().size());
        this.addedDescriptors = new ArrayList(this.histCfg.getAdded().size());
    }

    public boolean gatherHistoricalModels() throws CloverException, IOException {
        File[] historyFiles = this.histCfg.getHistoryFiles();
        if (historyFiles == null) {
            historyFiles = FileUtils.listMatchingFilesForDir(this.histCfg.getHistoryDir(), "clover-.*.xml.gz");
        }
        this.models = this.isPackageLevel() ? HistoricalSupport.getPackageMetricsForRange(this.getPackage(), historyFiles, this.histCfg.getFromTS().getTime(), this.histCfg.getToTS().getTime()) : HistoricalSupport.getProjectMetricsForRange(historyFiles, this.histCfg.getFromTS().getTime(), this.histCfg.getToTS().getTime());
        int numts = this.models.keySet().size();
        if (numts == 0) {
            Logger.getInstance().debug("No historical data found. No report can be generated.");
            return false;
        }
        this.enoughForMovers = numts > 1;
        this.firstTS = (Long)this.models.firstKey();
        this.lastTS = (Long)this.models.lastKey();
        try {
            this.subjectMetrics = HistoricalSupport.getFullMetrics((HistoricalSupport.HasMetricsWrapper)this.models.get(this.lastTS), this.getPackage());
            if (this.showMovers()) {
                Iterator iter = this.histCfg.getMovers().iterator();
                while (iter.hasNext()) {
                    MoversDescriptor moversDescriptor = new MoversDescriptor((Historical.Movers)iter.next());
                    moversDescriptor.gatherMovers();
                    this.moversDescriptors.add(moversDescriptor);
                }
                iter = this.histCfg.getAdded().iterator();
                while (iter.hasNext()) {
                    AddedDescriptor addedDescriptor = new AddedDescriptor((Historical.Movers)iter.next());
                    addedDescriptor.gatherMovers();
                    this.addedDescriptors.add(addedDescriptor);
                }
            }
            return true;
        }
        catch (Exception e) {
            String msg = "An error occured reading historical data (" + e.getClass().getName() + ":" + e.getMessage() + ")";
            Logger.getInstance().debug(msg, e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean showOverview() {
        return this.histCfg.getOverview() != null;
    }

    public boolean showMovers() {
        return this.enoughForMovers && this.histCfg.getMovers().size() > 0;
    }

    public boolean isPackageLevel() {
        return this.getPackage() != null;
    }

    public String getPackage() {
        return this.histCfg.getPackage();
    }

    public String getSubjectName() {
        if (this.isPackageLevel()) {
            return this.subjectMetrics.getName();
        }
        return "";
    }

    public String getSubjectType() {
        if (this.isPackageLevel()) {
            return "Package";
        }
        return "Project";
    }

    public HasMetrics getSubjectMetrics() {
        return this.subjectMetrics;
    }

    public long getFirstTimestamp() {
        return this.firstTS;
    }

    public long getLastTimestamp() {
        return this.lastTS;
    }

    public SortedMap getHistoricalModels() {
        return this.models;
    }

    public List getMoversDescriptors() {
        return this.moversDescriptors;
    }

    public List getAddedDescriptors() {
        return this.addedDescriptors;
    }

    private Long getFirstTSAfter(List timestamps, Long lastTS, Interval requested) {
        Collections.reverse(timestamps);
        Long firstTS = (Long)timestamps.get(1);
        if (requested != null) {
            long requestedTS = lastTS - requested.getValueInMillis();
            if (requestedTS >= lastTS) {
                this.log.warn("Ignoring interval setting of " + requested + ". ");
            } else {
                Long ts;
                Iterator it = timestamps.iterator();
                while (it.hasNext() && (ts = (Long)it.next()) >= requestedTS) {
                    firstTS = ts;
                }
            }
        }
        if (firstTS.equals(lastTS)) {
            firstTS = (Long)timestamps.get(1);
        }
        return firstTS;
    }

    public class MoversDescriptor {
        Historical.Movers movers;
        private Interval moversInterval;
        private List positiveMovers;
        private List negativeMovers;

        public MoversDescriptor() {
        }

        public MoversDescriptor(Historical.Movers movers) {
            this.movers = movers;
        }

        public void gatherMovers() throws Exception {
            Interval requested = this.movers.getInterval();
            Long firstTS = HistoricalReportDescriptor.this.getFirstTSAfter(new LinkedList(HistoricalReportDescriptor.this.models.keySet()), HistoricalReportDescriptor.this.lastTS, requested);
            this.moversInterval = this.calcActualInterval(HistoricalReportDescriptor.this.lastTS, firstTS, requested);
            HasMetrics fromMetrics = HistoricalSupport.getFullMetrics((HistoricalSupport.HasMetricsWrapper)HistoricalReportDescriptor.this.models.get(firstTS), HistoricalReportDescriptor.this.getPackage());
            Column column = this.movers.getColumn();
            List moverClasses = this.getMoverClasses(fromMetrics, column);
            if (column.getFormat() instanceof ColumnFormat.PercentageColumnFormat) {
                this.movers.setMaxWidth(100);
            } else {
                this.movers.setMaxWidth(column.getNumber().intValue());
            }
            int lastMover = moverClasses.size() - 1;
            int range = this.movers.getRange();
            if (moverClasses.size() > 0) {
                this.positiveMovers = this.getPositiveMovers(moverClasses, lastMover, range);
                this.negativeMovers = this.getNegativeMovers(moverClasses, range);
            } else {
                this.positiveMovers = new ArrayList();
                this.negativeMovers = new ArrayList();
            }
        }

        protected List getNegativeMovers(List moverClasses, int range) {
            MetricsDiffSummary diff = (MetricsDiffSummary)moverClasses.get(0);
            ArrayList<MetricsDiffSummary> negativeMovers = new ArrayList<MetricsDiffSummary>();
            if (diff.getPcDiff() < 0.0f) {
                Iterator bottom = moverClasses.iterator();
                for (int i = 0; i < range && bottom.hasNext() && !((diff = (MetricsDiffSummary)bottom.next()).getPcDiff() >= 0.0f); ++i) {
                    negativeMovers.add(diff);
                }
            }
            return negativeMovers;
        }

        protected List getPositiveMovers(List moverClasses, int lastMover, int range) {
            return this.getPositiveMoversInner(moverClasses, lastMover, range, false);
        }

        protected List getPositiveMoversInner(List moverClasses, int lastMover, int range, boolean includeZero) {
            MetricsDiffSummary diff = (MetricsDiffSummary)moverClasses.get(lastMover);
            ArrayList<MetricsDiffSummary> positiveMovers = new ArrayList<MetricsDiffSummary>();
            if (diff.getPcDiff() > 0.0f || includeZero && diff.getPcDiff() == 0.0f) {
                ListIterator top = moverClasses.listIterator(lastMover + 1);
                for (int i = 0; i < range && top.hasPrevious() && !((diff = (MetricsDiffSummary)top.previous()).getPcDiff() < 0.0f) && (includeZero || diff.getPcDiff() != 0.0f); ++i) {
                    positiveMovers.add(diff);
                }
            }
            return positiveMovers;
        }

        protected List getMoverClasses(HasMetrics fromMetrics, Column column) throws CloverException {
            return HistoricalSupport.getClassesMetricsDifference(fromMetrics, HistoricalReportDescriptor.this.subjectMetrics, this.movers.getThreshold(), column, true);
        }

        private Interval calcActualInterval(Long lastTS, Long firstTS, Interval requested) {
            Interval actual = new Interval((lastTS - firstTS) / 1000L, 0);
            if (requested != null && !actual.equals(requested)) {
                HistoricalReportDescriptor.this.log.info("movers interval adjusted to " + actual.toSensibleString());
            } else {
                HistoricalReportDescriptor.this.log.info("using movers interval of " + actual.toSensibleString());
            }
            return actual;
        }

        public Interval getRequestedInterval() {
            if (HistoricalReportDescriptor.this.showMovers()) {
                Interval interval = this.movers.getInterval();
                if (interval == null) {
                    interval = this.getActualInterval();
                }
                return interval;
            }
            return null;
        }

        public int getMaxWidth() {
            return this.movers.getMaxWidth();
        }

        public List getGainers() {
            return this.positiveMovers;
        }

        public List getLosers() {
            return this.negativeMovers;
        }

        public Interval getActualInterval() {
            return this.moversInterval;
        }

        public Interval getInterval() {
            return this.movers.getInterval();
        }

        public Percentage getThreshold() {
            return this.movers.getThreshold();
        }

        public Column getColumn() {
            return this.movers.getColumn();
        }

        public int getRange() {
            return this.movers.getRange();
        }
    }

    public class AddedDescriptor
    extends MoversDescriptor {
        public AddedDescriptor(Historical.Movers movers) {
            this.movers = movers;
        }

        protected List getPositiveMovers(List moverClasses, int lastMover, int range) {
            if (moverClasses.size() <= range) {
                Collections.sort(moverClasses, MetricsDiffSummary.INVERSE_DIFF_COMP);
                return this.removeAllEmpty(moverClasses);
            }
            List topN = this.getPositiveMoversInner(moverClasses, lastMover, range, true);
            Collections.sort(topN, MetricsDiffSummary.INVERSE_DIFF_COMP);
            List bottomN = this.getBottomMovers(moverClasses, range);
            ArrayList result = new ArrayList(topN.size() + bottomN.size());
            result.addAll(topN);
            result.addAll(bottomN);
            return this.removeAllEmpty(result);
        }

        private List removeAllEmpty(List result) {
            LinkedList<MetricsDiffSummary> nonEmpty = new LinkedList<MetricsDiffSummary>();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                MetricsDiffSummary diffSummary = (MetricsDiffSummary)iterator.next();
                if (diffSummary.getCurrentClassInfo().getMetrics().isEmpty()) continue;
                nonEmpty.add(diffSummary);
            }
            return nonEmpty;
        }

        protected List getBottomMovers(List moverClasses, int range) {
            int toIndex = moverClasses.size() > range ? range : moverClasses.size();
            return moverClasses.subList(0, toIndex);
        }

        protected List getMoverClasses(HasMetrics fromMetrics, Column column) throws CloverException {
            return HistoricalSupport.getClassesMetricsDifference(fromMetrics, HistoricalReportDescriptor.this.subjectMetrics, this.movers.getThreshold(), column, false);
        }
    }
}

