/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.pdf;

import clover.com.lowagie.text.Document;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.PageSize;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.pdf.PdfWriter;
import com.atlassian.clover.api.CloverException;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.CodeType;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsSupport;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.CloverReporter;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.reporters.pdf.PDFColours;
import com.cenqua.clover.reporters.pdf.PageFooterRenderer;
import com.cenqua.clover.reporters.pdf.RenderingSupport;
import com.cenqua.clover.reporters.util.HistoricalReportDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class PDFReporter
extends CloverReporter {
    private static final Rectangle DEFAULT_PAGE_SIZE = PageSize.A4;
    private static final Map<String, Rectangle> SUPPORTED_PAGE_SIZES = new HashMap<String, Rectangle>();
    private final Document document;
    private final PDFColours colours;
    private final String reportTitle;
    private final String titleAnchor;
    private final Rectangle docsize;
    private final PdfWriter docWriter;
    private final CloverReportConfig[] secondaryConfigs;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$pdf$PDFReporter;

    public PDFReporter(CloverReportConfig config) throws CloverException {
        this(config, new CloverReportConfig[0]);
    }

    public PDFReporter(CloverReportConfig config, CloverReportConfig[] secondaryConfigs) throws CloverException {
        super(config);
        try {
            this.secondaryConfigs = secondaryConfigs;
            this.reportTitle = config.getTitle();
            this.titleAnchor = config.getTitleAnchor() != null ? config.getTitleAnchor() : "";
            this.colours = config.getFormat().getBw() ? PDFColours.BW_COLOURS : PDFColours.COL_COLOURS;
            this.docsize = this.getConfiguredPageSize(config);
            this.document = new Document(this.docsize, 25.0f, 25.0f, 25.0f, 35.0f);
            this.document.addTitle("Clover Coverage Report");
            this.document.addCreator("Clover 3.1.11 using iText v0.96");
            this.docWriter = PdfWriter.getInstance(this.document, new FileOutputStream(config.getOutFile()));
            this.docWriter.setPageEvent(new PageFooterRenderer(this.docsize, System.currentTimeMillis(), this.colours));
        }
        catch (Exception e) {
            throw new CloverException("Report rendering error: " + e.getMessage());
        }
    }

    protected int executeImpl() throws CloverException {
        this.open();
        boolean written = this.write(this.reportConfig);
        CloverReportConfig[] arr$ = this.secondaryConfigs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CloverReportConfig secondaryConfig = arr$[i$];
            this.write(secondaryConfig);
        }
        if (written) {
            this.close();
            return 0;
        }
        return 1;
    }

    protected void validate() throws CloverException {
        super.validate();
        CloverReportConfig[] arr$ = this.secondaryConfigs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CloverReportConfig secondaryConfig = arr$[i$];
            if (secondaryConfig.validate()) continue;
            throw new CloverException(secondaryConfig.getValidationFailureReason());
        }
    }

    private void open() {
        this.document.open();
    }

    private void close() {
        this.document.close();
    }

    private Rectangle getConfiguredPageSize(CloverReportConfig cfg) {
        Rectangle size;
        String sizeStr = cfg.getFormat().getPageSize();
        if (sizeStr != null) {
            size = SUPPORTED_PAGE_SIZES.get(sizeStr);
            if (size == null) {
                Logger.getInstance().warn("Unsupported Page Size '" + sizeStr + "', using default.");
                size = DEFAULT_PAGE_SIZE;
            }
        } else {
            size = DEFAULT_PAGE_SIZE;
        }
        return size;
    }

    private boolean write(CloverReportConfig config) throws CloverException {
        try {
            if (config instanceof Current) {
                if (!config.isAlwaysReport() && !config.getCoverageDatabase().hasCoverage()) {
                    Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
                    return false;
                }
                this.generateCurrentReport((Current)config);
            } else {
                HistoricalReportDescriptor desc = new HistoricalReportDescriptor(config);
                boolean hasHistoricalData = desc.gatherHistoricalModels();
                if (!hasHistoricalData) {
                    Logger.getInstance().warn("No historical data found. No PDF historical report can be generated.");
                    return false;
                }
                this.generateHistoricalReport((Historical)config, desc);
            }
        }
        catch (Exception e) {
            throw new CloverException("Report rendering error: " + e.getMessage(), e);
        }
        return true;
    }

    private void newPage() throws DocumentException, IOException {
        this.document.newPage();
        this.document.add(RenderingSupport.createHistoricalPageHeader(this.reportTitle, this.titleAnchor, this.colours));
        if (CloverLicenseInfo.EXPIRED) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
    }

    private void generateHistoricalReport(Historical historicalConfig, HistoricalReportDescriptor desc) throws CloverException, DocumentException, IOException {
        this.document.add(RenderingSupport.createHistoricalReportHeader(desc.getSubjectMetrics(), desc.getFirstTimestamp(), desc.getLastTimestamp(), this.reportTitle, this.titleAnchor, !desc.isPackageLevel(), this.colours));
        if (CloverLicenseInfo.EXPIRED) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
        if (desc.showOverview()) {
            LinkedList<HasMetrics> parentItem = new LinkedList<HasMetrics>();
            parentItem.add(desc.getSubjectMetrics());
            this.document.add(RenderingSupport.createCoverageDataTable(historicalConfig, desc.getSubjectName(), parentItem, this.colours));
            this.document.add(RenderingSupport.getSpacerRow());
        }
        int chartsOnPage = 0;
        List charts = historicalConfig.getCharts();
        SortedMap data = desc.getHistoricalModels();
        int numCharts = charts.size();
        for (int i = 0; i < numCharts; ++i) {
            if (chartsOnPage == 2) {
                this.newPage();
                chartsOnPage = 0;
            }
            Historical.Chart coverage = (Historical.Chart)charts.get(i);
            coverage.setHeight((int)(0.33f * this.docsize.height()));
            this.document.add(RenderingSupport.createChart(coverage, data, this.colours));
            this.document.add(RenderingSupport.getSpacerRow());
            ++chartsOnPage;
        }
        if (desc.showMovers()) {
            if (chartsOnPage == 2) {
                this.newPage();
                chartsOnPage = 0;
            }
            Iterator iter = desc.getAddedDescriptors().iterator();
            while (iter.hasNext()) {
                this.document.add(RenderingSupport.createAddedTable((HistoricalReportDescriptor.AddedDescriptor)iter.next(), this.colours));
                if (!iter.hasNext() && desc.getMoversDescriptors().isEmpty()) continue;
                this.document.add(RenderingSupport.getSpacerRow());
            }
            iter = desc.getMoversDescriptors().iterator();
            while (iter.hasNext()) {
                this.document.add(RenderingSupport.createMoversTable((HistoricalReportDescriptor.MoversDescriptor)iter.next(), this.colours));
                if (!iter.hasNext()) continue;
                this.document.add(RenderingSupport.getSpacerRow());
            }
        }
        this.document.newPage();
    }

    private void generateCurrentReport(Current currentConfig) throws CloverException, DocumentException {
        ProjectInfo project = this.database.getModel(CodeType.APPLICATION);
        Logger.getInstance().debug("creating project summary report");
        ProjectInfo parent = project;
        List<? extends BasePackageInfo> children = project.getPackages();
        Logger.getInstance().debug("num packages = " + children.size());
        String parentTitle = "";
        String childrenTitle = "Packages";
        this.document.add(RenderingSupport.createReportHeader(project, this.database.getRecordingTimestamp(), this.reportTitle, this.titleAnchor, this.colours));
        if (CloverLicenseInfo.EXPIRED) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
        this.document.add(RenderingSupport.createCoverageDataTable(currentConfig, parentTitle, Collections.singletonList(parent), this.colours));
        this.document.add(RenderingSupport.getSpacerRow());
        Collections.sort(children, HasMetricsSupport.getHasMetricsComparator(currentConfig.getFormat().getOrderby()));
        this.document.add(RenderingSupport.createCoverageDataTable(currentConfig, childrenTitle, children, this.colours));
        this.document.newPage();
    }

    protected long getPerms() {
        return 4L;
    }

    public static void main(String[] args) {
        PDFReporter.loadLicense();
        System.exit(PDFReporter.runReport(args));
    }

    public static int runReport(String[] args) {
        CloverReportConfig config = PDFReporter.processArgs(args);
        if (PDFReporter.canProceedWithReporting(config)) {
            try {
                return new PDFReporter(config, new CloverReportConfig[0]).execute();
            }
            catch (Exception e) {
                Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    private static CloverReportConfig processArgs(String[] args) {
        Current config = new Current(Current.DEFAULT_PDF);
        config.setFormat(Format.DEFAULT_PDF);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") || args[i].equals("--outputfile")) {
                    config.setOutFile(new File(args[++i]));
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    config.setInitString(args[++i]);
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--title")) {
                    config.setTitle(args[++i]);
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("--pagesize")) {
                    config.getFormat().setPageSize(args[++i]);
                    continue;
                }
                if (args[i].equals("-a") || args[i].equals("--alwaysreport")) {
                    config.setAlwaysReport(true);
                    continue;
                }
                if (args[i].equals("-b") || args[i].equals("--hidebars")) {
                    config.getFormat().setShowBars(false);
                    continue;
                }
                if (args[i].equals("-e") || args[i].equals("--showempty")) {
                    config.getFormat().setShowEmpty(true);
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--span")) {
                    ++i;
                    try {
                        config.setSpan(new Interval(args[i]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        PDFReporter.usage("Invalid interval format. Should be integer followed by unit (s, m, h, d, w).");
                        return null;
                    }
                }
                if (args[i].equals("-c") || args[i].equals("--orderby")) {
                    config.getFormat().setOrderby(args[++i]);
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (args[i].equals("-if") || args[i].equals("--includefailcoverage")) {
                    config.setIncludeFailedTestCoverage(true);
                    continue;
                }
                if (args[i].equals("-f") || args[i].equals("--filter")) {
                    config.getFormat().setFilter(args[++i]);
                    continue;
                }
                if (!args[i].equals("-tc") && !args[i].equals("--threadcount")) continue;
                ++i;
                try {
                    int threadCount = Integer.parseInt(args[i]);
                    if (threadCount < 0) {
                        PDFReporter.usage("Invalid thread count. Should be zero or a positive integer.");
                        return null;
                    }
                    config.setNumThreads(threadCount);
                    continue;
                }
                catch (NumberFormatException e) {
                    PDFReporter.usage("Invalid thread count. Should be an integer.");
                    return null;
                }
            }
            if (!config.validate()) {
                PDFReporter.usage(config.getValidationFailureReason());
                config = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            PDFReporter.usage("Missing a parameter.");
            config = null;
        }
        return config;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer().append("  USAGE: ");
        Class<?> clazz = class$com$cenqua$clover$reporters$pdf$PDFReporter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$reporters$pdf$PDFReporter = new PDFReporter[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" [OPTIONS] PARAMS\n\n").append("  PARAMS:\n").append("    -i,  --initstring <string>\tclover initstring\n\n").append("    -o,  --outputfile <file>\tfile to write PDF to.\n\n").append("  OPTIONS:\n").append("    -t,  --title <string>\treport title.\n\n").append("    -e,  --showempty\t\tshow classes/packages even if they don't have any\n").append("\t\t\t\tstatements, methods or conditionals. default is false\n\n").append("    -b,  --hidebars\t\tdon't render coverage bars. default is false.\n\n").append("    -p,  --pagesize <size>\tPage size to use. Valid values are \"A4\",\"Letter\". Default is \"A4\".\n\n").append("    -tc, --threadcount <int>\tnumber of additional threads to be allocated to report generation. Default is 0.\n\n").append("    -s, --span <interval>\tSpecifies how far back in time to\n").append("\t\t\t\tinclude coverage recordings from since the last Clover build. In Interval\n").append("\t\t\t\tformat. \"60s\" = 60 seconds, \"1h\" = 1 hour, \"1d\" = 1 day etc.\n\n").append("    -d,  --debug \t\tswitch logging level to debug\n\n").append("    -v,  --verbose \t\tswitch logging level to verbose\n\n").append("    -a,  --alwaysreport\t\tgenerate report even if there is no coverage to report on\n\n").append("    -if, --includefailcoverage\tinclude coverage from failed tests. Default is false.\n\n").append("    -f,  --filter <string>\tcomma separated list of contexts to filter\n").append("\t\t\t\twhen generating coverage reports. Most useful one is \"catch\".\n").append("\t\t\t\tvalid values are \"static\",\"instance\",\"constructor\",\"method\",\"switch\",\n").append("\t\t\t\t\"while\",\"do\",\"for\",\"if\",\"else\",\"try\",\"catch\",\"finally\",\"sync\"\n\n").append("    -c,  --orderby <compname>\tcomparator to use when listing packages and classes.\n").append("\t\t\t\tvalid values are \"alpha\" - alphabetic, \"desc\" - coverage descending,\n").append("\t\t\t\t\"asc\" - coverage ascending. default is \"asc\".\n\n").toString());
    }

    static {
        SUPPORTED_PAGE_SIZES.put("A4", PageSize.A4);
        SUPPORTED_PAGE_SIZES.put("LETTER", PageSize.LETTER);
    }
}

