/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import com.atlassian.clover.api.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.CloverReporter;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.html.HtmlRenderingSupportImpl;
import com.cenqua.clover.reporters.json.RenderCloudsJSONAction;
import com.cenqua.clover.reporters.json.RenderColophonJSONAction;
import com.cenqua.clover.reporters.json.RenderFileJSONAction;
import com.cenqua.clover.reporters.json.RenderMetricsJSONAction;
import com.cenqua.clover.util.CloverExecutor;
import com.cenqua.clover.util.CloverExecutors;
import com.cenqua.clover.util.CloverUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class JSONReporter
extends CloverReporter {
    private final HtmlRenderingSupportImpl renderingHelper;
    private final File basePath;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$json$JSONReporter;

    public JSONReporter(CloverReportConfig config) throws CloverException {
        super(config);
        this.renderingHelper = new HtmlRenderingSupportImpl(config.getFormat(), true);
        this.basePath = config.getOutFile();
    }

    protected long getPerms() {
        return 8L;
    }

    private Current getConfigAsCurrent() {
        return (Current)this.reportConfig;
    }

    public int executeImpl() throws CloverException {
        long currentStartTime = System.currentTimeMillis();
        ProjectInfo projectInfo = this.database.getAppOnlyModel();
        projectInfo.buildCaches();
        List<? extends BasePackageInfo> pkgs = projectInfo.getPackages();
        try {
            CloverUtils.createDir(this.basePath);
            CloverExecutor service = CloverExecutors.newCloverExecutor(this.getConfigAsCurrent().getNumThreads(), "Clover-JSON");
            Logger.getInstance().info("Generating JSON report to: " + this.getConfigAsCurrent().getOutFile().getAbsolutePath());
            RenderFileJSONAction.initThreadLocals();
            RenderMetricsJSONAction.initThreadLocals();
            service.submit(new RenderColophonJSONAction(new VelocityContext(), new File(this.getConfigAsCurrent().getOutFile(), "colophon.js"), this.getConfigAsCurrent()));
            service.submit(new RenderMetricsJSONAction(new VelocityContext(), projectInfo, this.getConfigAsCurrent(), new File(this.getConfigAsCurrent().getOutFile(), "project.js"), this.renderingHelper));
            service.submit(new RenderCloudsJSONAction.ForProjects.OfTheirRisks(projectInfo, new VelocityContext(), this.getConfigAsCurrent(), this.getConfigAsCurrent().getOutFile()));
            service.submit(new RenderCloudsJSONAction.ForProjects.OfTheirQuickWins(projectInfo, new VelocityContext(), this.getConfigAsCurrent(), this.getConfigAsCurrent().getOutFile()));
            Iterator<? extends BasePackageInfo> it = pkgs.iterator();
            while (it.hasNext()) {
                PackageInfo pkg = (PackageInfo)it.next();
                Logger.getInstance().verbose("Processing package " + pkg.getName());
                long start = System.currentTimeMillis();
                this.processPackage(pkg, service);
                long total = System.currentTimeMillis() - start;
                if (!Logger.isDebug()) continue;
                Logger.getInstance().debug("Processed package: " + pkg.getName() + " (" + pkg.getClasses().size() + " classes, " + pkg.getMetrics().getNumTests() + " tests)" + " in " + total + "ms");
            }
            service.shutdown();
            Interval timeOut = this.getConfigAsCurrent().getTimeOut();
            if (!service.awaitTermination(timeOut.getValueInMillis(), TimeUnit.MILLISECONDS)) {
                throw new CloverException("Timout of '" + timeOut + "' reached during report generation. " + "Please increase this value and try again.");
            }
        }
        catch (Exception e) {
            throw new CloverException(e);
        }
        finally {
            RenderFileJSONAction.resetThreadLocals();
            RenderMetricsJSONAction.resetThreadLocals();
        }
        long currentTotalTime = System.currentTimeMillis() - currentStartTime;
        int pkgCount = pkgs.size();
        long msPerPkg = pkgCount == 0 ? currentTotalTime : currentTotalTime / (long)pkgCount;
        Logger.getInstance().info("Done. Processed " + pkgCount + " packages in " + currentTotalTime + "ms (" + msPerPkg + "ms per package).");
        return 0;
    }

    private void processPackage(PackageInfo pkg, CloverExecutor service) throws Exception {
        List files = pkg.getFiles();
        ProjectInfo projectInfo = this.database.getFullModel();
        projectInfo.buildCaches();
        File basedir = CloverUtils.createOutDir(pkg, this.getConfigAsCurrent().getOutFile());
        File outfile = new File(basedir, "package.js");
        service.submit(new RenderMetricsJSONAction(new VelocityContext(), pkg, this.getConfigAsCurrent(), outfile, this.renderingHelper));
        service.submit(new RenderCloudsJSONAction.ForPackages.OfTheirRisks(new VelocityContext(), pkg, this.getConfigAsCurrent(), basedir, true));
        service.submit(new RenderCloudsJSONAction.ForPackages.OfTheirRisks(new VelocityContext(), pkg, this.getConfigAsCurrent(), basedir, false));
        service.submit(new RenderCloudsJSONAction.ForPackages.OfTheirQuickWins(new VelocityContext(), pkg, this.getConfigAsCurrent(), basedir, true));
        service.submit(new RenderCloudsJSONAction.ForPackages.OfTheirQuickWins(new VelocityContext(), pkg, this.getConfigAsCurrent(), basedir, false));
        Iterator it = files.iterator();
        while (it.hasNext()) {
            service.submit(new RenderFileJSONAction((FileInfo)it.next(), this.renderingHelper, this.getConfigAsCurrent(), new VelocityContext(), this.database, projectInfo));
        }
    }

    public static void main(String[] args) {
        JSONReporter.loadLicense();
        System.exit(JSONReporter.runReport(args));
    }

    public static int runReport(String[] args) {
        Current config = JSONReporter.processArgs(args);
        if (JSONReporter.canProceedWithReporting(config)) {
            try {
                return new JSONReporter(config).execute();
            }
            catch (Exception e) {
                Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer().append("  USAGE: ");
        Class<?> clazz = class$com$cenqua$clover$reporters$json$JSONReporter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$reporters$json$JSONReporter = new JSONReporter[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" [OPTIONS] PARAMS\n\n").append("  PARAMS:\n").append("    -i,  --initstring <string>\tclover initstring\n\n").append("    -o,  --outputdir <dir>\toutput directory for generated json.\n\n").append("  OPTIONS:\n").append("    -tc, --threadcount <int>\tnumber of additional threads to be allocated to report generation. Default is 0.\n\n").append("    -d,  --debug \t\tswitch logging level to debug\n\n").append("    -v,  --verbose \t\tswitch logging level to verbose\n\n").append("    -a,  --alwaysreport\t\tgenerate report even if there is no coverage to report on\n\n").append("    -if, --includefailcoverage\tinclude coverage from failed tests. Default is false.\n\n").toString());
    }

    public static Current processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_JSON);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") || args[i].equals("--outputdir")) {
                    cfg.setOutFile(new File(args[++i]));
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    cfg.setInitString(args[++i]);
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                if (args[i].equals("-a") || args[i].equals("--alwaysreport")) {
                    cfg.setAlwaysReport(true);
                    continue;
                }
                if (args[i].equals("-tc") || args[i].equals("--threadcount")) {
                    ++i;
                    try {
                        int threadCount = Integer.parseInt(args[i]);
                        if (threadCount < 0) {
                            JSONReporter.usage("Invalid thread count. Should be zero or a positive integer.");
                            return null;
                        }
                        cfg.setNumThreads(threadCount);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        JSONReporter.usage("Invalid thread count. Should be an integer.");
                        return null;
                    }
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (!args[i].equals("-if") && !args[i].equals("--includefailcoverage")) continue;
                cfg.setIncludeFailedTestCoverage(true);
            }
            if (!cfg.validate()) {
                JSONReporter.usage(cfg.getValidationFailureReason());
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JSONReporter.usage("Missing a parameter.");
            return null;
        }
        return cfg;
    }
}

