/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.json;

import com.atlassian.clover.api.CloverException;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.Columns;
import com.cenqua.clover.reporters.html.HtmlRenderingSupportImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONReportUtils {
    public static Map collectColumnValuesFor(List columns, HasMetrics mInfo, HtmlRenderingSupportImpl mHelper) throws CloverException {
        Map columnValues = mHelper.collectColumnValues(columns, mInfo);
        BlockMetrics metrics = mHelper.metricsFor(mInfo);
        columnValues.put("Tests", new Integer(metrics.getNumTests()));
        columnValues.put("PassingTests", new Integer(metrics.getNumTestPasses()));
        columnValues.put("FailingTests", new Integer(metrics.getNumTestFailures()));
        columnValues.put("ErroneousTests", new Integer(metrics.getNumTestErrors()));
        columnValues.put("TestExecutionTime", new Float(metrics.getTestExecutionTime()));
        columnValues.put("PcPassingTests", new Float(metrics.getPcTestPasses()));
        columnValues.put("PcFailingTests", new Float(metrics.getPcTestFailures()));
        columnValues.put("PcErroneousTests", new Float(metrics.getPcTestErrors()));
        return columnValues;
    }

    public static List getColumnNames(CloverReportConfig cfg) {
        List<Column> columns = cfg.isColumnsSet() ? cfg.getColumns().getProjectColumnsCopy() : Columns.getAllColumns();
        ArrayList<String> columnNames = new ArrayList<String>(columns.size() + 5);
        Iterator<Column> iterator = columns.iterator();
        while (iterator.hasNext()) {
            columnNames.add(iterator.next().getName());
        }
        columnNames.add("Tests");
        columnNames.add("PassingTests");
        columnNames.add("FailingTests");
        columnNames.add("ErroneousTests");
        columnNames.add("TestExecutionTime");
        columnNames.add("PcPassingTests");
        columnNames.add("PcFailingTests");
        columnNames.add("PcErroneousTests");
        return columnNames;
    }
}

