/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.reporters.html.ClassInfoStatsCalculator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsClassInfoVisitor {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private final Map<BaseClassInfo, String> classes = new LinkedHashMap<BaseClassInfo, String>();
    private final ClassInfoStatsCalculator calculator;

    public StatisticsClassInfoVisitor(ClassInfoStatsCalculator calculator) {
        this.calculator = calculator;
    }

    public void visitClassInfo(BaseClassInfo classInfo) {
        if (!this.calculator.ignore(classInfo)) {
            int count = this.calculator.getScaledValue(classInfo);
            this.classes.put(classInfo, this.calculator.getFormattedValue(classInfo));
            if ((long)count <= this.min) {
                this.min = count;
            }
            if ((long)count >= this.max) {
                this.max = count;
            }
        }
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getRange() {
        return this.max - this.min;
    }

    public List<BaseClassInfo> getClasses() {
        return new ArrayList<BaseClassInfo>(this.classes.keySet());
    }

    public boolean hasClassInfo(BaseClassInfo info) {
        return this.classes.containsKey(info);
    }

    public ClassInfoStatsCalculator getCalculator() {
        return this.calculator;
    }

    public static StatisticsClassInfoVisitor visit(List<BaseClassInfo> classes, ClassInfoStatsCalculator statsCalculator) {
        StatisticsClassInfoVisitor visitor = new StatisticsClassInfoVisitor(statsCalculator);
        for (int i = 0; i < classes.size(); ++i) {
            visitor.visitClassInfo(classes.get(i));
        }
        return visitor;
    }
}

