/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.atlassian.clover.api.CloverException;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Logger;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.reporters.Type;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.HtmlReporter;
import com.cenqua.clover.reporters.json.JSONReporter;
import com.cenqua.clover.reporters.pdf.PDFReporter;
import com.cenqua.clover.reporters.xml.XMLReporter;

public abstract class CloverReporter {
    protected final CloverDatabase database;
    protected final CloverReportConfig reportConfig;

    protected static void loadLicense() {
        CloverStartup.loadLicense(Logger.getInstance());
    }

    protected CloverReporter(CloverDatabase database, CloverReportConfig reportConfig) {
        this.database = database;
        this.reportConfig = reportConfig;
    }

    public CloverReporter(CloverReportConfig reportConfig) throws CloverException {
        this(reportConfig.getCoverageDatabase(), reportConfig);
    }

    public final int execute() throws CloverException {
        this.validate();
        CloverStartup.permsCheck(this.getPerms());
        return this.executeImpl();
    }

    protected void validate() throws CloverException {
        if (!this.reportConfig.validate()) {
            throw new CloverException(this.reportConfig.getValidationFailureReason());
        }
        if (this.database == null && !this.isHistoricalReport()) {
            throw new CloverException("You must supply an initstring for a current PDF report");
        }
    }

    protected abstract int executeImpl() throws CloverException;

    protected abstract long getPerms();

    protected static boolean canProceedWithReporting(CloverReportConfig config) {
        return config != null && HtmlReportUtil.getVelocityEngine() != null;
    }

    public static CloverReporter buildReporter(CloverReportConfig config) throws CloverException {
        if (!config.validate()) {
            throw new CloverException(config.getValidationFailureReason());
        }
        switch (1.$SwitchMap$com$cenqua$clover$reporters$Type[config.getFormat().getType().ordinal()]) {
            case 1: {
                return new PDFReporter(config);
            }
            case 2: {
                return new XMLReporter(config);
            }
            case 3: {
                return new JSONReporter(config);
            }
        }
        return new HtmlReporter(config);
    }

    protected boolean isCurrentReport() {
        return this.reportConfig instanceof Current;
    }

    protected boolean isHistoricalReport() {
        return this.reportConfig instanceof Historical;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$cenqua$clover$reporters$Type;

        static {
            $SwitchMap$com$cenqua$clover$reporters$Type = new int[Type.values().length];
            try {
                1.$SwitchMap$com$cenqua$clover$reporters$Type[Type.PDF.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$cenqua$clover$reporters$Type[Type.XML.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$cenqua$clover$reporters$Type[Type.JSON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

