/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.api.registry.ModifiersInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.cenqua.clover.registry.Annotation;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modifiers
implements TaggedPersistent,
ModifiersInfo {
    private int mask = 0;
    private Map<String, Annotation> annotations = new HashMap<String, Annotation>();
    static /* synthetic */ Class class$com$cenqua$clover$registry$Annotation;

    public static Modifiers createFrom(int modifiers, Annotation[] annotations) {
        Modifiers result = new Modifiers();
        result.setMask(modifiers);
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                result.addAnnotation(annotation);
            }
        }
        return result;
    }

    public boolean containsAnnotation(String name) {
        return this.annotations.containsKey(name);
    }

    public boolean containsAnnotation(Pattern pattern) {
        for (String annoName : this.annotations.keySet()) {
            if (!pattern.matcher(annoName).matches()) continue;
            return true;
        }
        return false;
    }

    public Annotation getAnnotation(String name) {
        return this.annotations.get(name);
    }

    public Map<String, Annotation> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.getName(), annotation);
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    public String getVisibility() {
        int visibilityMods = this.mask & 7;
        if (visibilityMods == 0) {
            return "package";
        }
        return Modifier.toString(visibilityMods);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeInt(this.mask);
        Collection<Annotation> entries = this.annotations.values();
        out.writeInt(entries.size());
        for (Annotation entry : entries) {
            Class<?> clazz = class$com$cenqua$clover$registry$Annotation;
            if (clazz == null) {
                clazz = new Annotation[0].getClass().getComponentType();
            }
            out.write(clazz, entry);
        }
    }

    public static Modifiers read(TaggedDataInput in) throws IOException {
        Modifiers result = new Modifiers();
        result.setMask(in.readInt());
        int entriesSize = in.readInt();
        for (int i = 0; i < entriesSize; ++i) {
            Class<?> clazz = class$com$cenqua$clover$registry$Annotation;
            if (clazz == null) {
                clazz = new Annotation[0].getClass().getComponentType();
            }
            result.addAnnotation((Annotation)in.read(clazz));
        }
        return result;
    }

    public String toString() {
        return new StringBuffer().append("Modifiers{modifiers=").append(Modifier.toString(this.mask)).append(", annotations=").append(this.annotations).append('}').toString();
    }
}

