/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.StackTraceInfo;
import com.cenqua.clover.registry.StatementInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineInfo {
    public static Comparator<ElementInfo> COLUMN_COMPARATOR = new Comparator<ElementInfo>(){

        @Override
        public int compare(ElementInfo a, ElementInfo b) {
            if (a.getStartColumn() < b.getStartColumn()) {
                return -1;
            }
            if (a.getStartColumn() > b.getStartColumn()) {
                return 1;
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((ElementInfo)x0, (ElementInfo)x1);
        }
    };
    private int line;
    private static final ClassInfo[] EMPTY_CLASS_INFOS = new ClassInfo[0];
    private static final MethodInfo[] EMPTY_METHOD_INFOS = new MethodInfo[0];
    private static final StatementInfo[] EMPTY_STATEMENT_INFOS = new StatementInfo[0];
    private static final BranchInfo[] EMPTY_BRANCH_INFOS = new BranchInfo[0];
    private List<ClassInfo> classStarts;
    private List<MethodInfo> methodStarts;
    private List<StatementInfo> statements;
    private List<BranchInfo> branches;
    private StackTraceInfo.TraceEntry[] failStackEntries;

    public LineInfo(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public List<ElementInfo> getColumnOrderedElementInfos() {
        ArrayList<ElementInfo> elements = new ArrayList<ElementInfo>();
        if (this.methodStarts != null) {
            elements.addAll(this.methodStarts);
        }
        if (this.statements != null) {
            elements.addAll(this.statements);
        }
        if (this.branches != null) {
            elements.addAll(this.branches);
        }
        Collections.sort(elements, COLUMN_COMPARATOR);
        return elements;
    }

    public ClassInfo[] getClassStarts() {
        if (this.classStarts == null) {
            return EMPTY_CLASS_INFOS;
        }
        return this.classStarts.toArray(new ClassInfo[this.classStarts.size()]);
    }

    public MethodInfo[] getMethodStarts() {
        if (this.methodStarts == null) {
            return EMPTY_METHOD_INFOS;
        }
        return this.methodStarts.toArray(new MethodInfo[this.methodStarts.size()]);
    }

    public StatementInfo[] getStatements() {
        if (this.statements == null) {
            return EMPTY_STATEMENT_INFOS;
        }
        return this.statements.toArray(new StatementInfo[this.statements.size()]);
    }

    public BranchInfo[] getBranches() {
        if (this.branches == null) {
            return EMPTY_BRANCH_INFOS;
        }
        return this.branches.toArray(new BranchInfo[this.branches.size()]);
    }

    public StackTraceInfo.TraceEntry[] getFailStackEntries() {
        return this.failStackEntries;
    }

    void addClassStart(ClassInfo clazz) {
        if (this.classStarts == null) {
            this.classStarts = new ArrayList<ClassInfo>();
        }
        this.classStarts.add(clazz);
    }

    void addMethodStart(MethodInfo method) {
        if (this.methodStarts == null) {
            this.methodStarts = new ArrayList<MethodInfo>();
        }
        this.methodStarts.add(method);
    }

    void addStatement(StatementInfo stmt) {
        if (this.statements == null) {
            this.statements = new ArrayList<StatementInfo>();
        }
        this.statements.add(stmt);
    }

    void addBranch(BranchInfo branch) {
        if (this.branches == null) {
            this.branches = new ArrayList<BranchInfo>();
        }
        this.branches.add(branch);
    }

    public void setFailStackEntries(StackTraceInfo.TraceEntry[] entries) {
        this.failStackEntries = new StackTraceInfo.TraceEntry[entries.length];
        System.arraycopy(entries, 0, this.failStackEntries, 0, entries.length);
    }

    public boolean hasMethodStarts() {
        return this.methodStarts != null;
    }

    public boolean hasClassStarts() {
        return this.classStarts != null;
    }

    public boolean hasFailStackEntries() {
        return this.failStackEntries != null;
    }

    public boolean hasBranches() {
        return this.branches != null;
    }

    public boolean hasStatements() {
        return this.statements != null;
    }
}

