/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.HasMetrics;

public class ClassMetrics
extends BlockMetrics {
    private int numMethods;
    private int numCoveredMethods;
    private int numTestMethods;

    public ClassMetrics(HasMetrics owner) {
        super(owner);
    }

    public String getType() {
        return "class";
    }

    public int getNumMethods() {
        return this.numMethods;
    }

    public void setNumMethods(int numMethods) {
        this.numMethods = numMethods;
    }

    public String getChildType() {
        return "method";
    }

    public int getNumChildren() {
        return this.getNumMethods();
    }

    public int getNumCoveredMethods() {
        return this.numCoveredMethods;
    }

    public void setNumCoveredMethods(int numCoveredMethods) {
        this.numCoveredMethods = numCoveredMethods;
    }

    public int getNumTestMethods() {
        return this.numTestMethods;
    }

    public void setNumTestMethods(int numTestMethods) {
        this.numTestMethods = numTestMethods;
    }

    public int getNumElements() {
        return super.getNumElements() + this.numMethods;
    }

    public int getNumCoveredElements() {
        return super.getNumCoveredElements() + this.numCoveredMethods;
    }

    public float getPcCoveredMethods() {
        return this.getFraction(this.getNumCoveredMethods(), this.getNumMethods());
    }

    public float getAvgMethodComplexity() {
        return this.getFraction(super.getComplexity(), this.getNumMethods());
    }

    public float getAvgStatementsPerMethod() {
        return this.getFraction(this.getNumStatements(), this.getNumMethods());
    }

    public ClassMetrics add(ClassMetrics metrics) {
        super.add(metrics);
        this.numMethods += metrics.numMethods;
        this.numCoveredMethods += metrics.numCoveredMethods;
        this.numTestMethods += metrics.numTestMethods;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClassMetrics that = (ClassMetrics)o;
        if (this.numCoveredMethods != that.numCoveredMethods) {
            return false;
        }
        if (this.numMethods != that.numMethods) {
            return false;
        }
        return this.numTestMethods == that.numTestMethods;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.numMethods;
        result = 31 * result + this.numCoveredMethods;
        result = 31 * result + this.numTestMethods;
        return result;
    }

    public String toString() {
        return "ClassMetrics{numMethods=" + this.numMethods + ", numCoveredMethods=" + this.numCoveredMethods + ", numTestMethods=" + this.numTestMethods + "} " + super.toString();
    }
}

