/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.api.registry.SourceInfo;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.FixedFileRegion;
import com.cenqua.clover.registry.HasMetrics;

public class BaseClassInfo
extends FixedFileRegion
implements HasMetrics {
    protected String name;
    protected String qualifiedName;
    protected boolean typeInterface;
    protected boolean typeEnum;
    protected boolean typeAnnotation;
    protected boolean testClass;
    protected transient BasePackageInfo packageInfo;
    protected transient BlockMetrics rawMetrics;
    protected transient BlockMetrics metrics;
    protected transient ContextSet contextFilter;

    public BaseClassInfo(BasePackageInfo packageInfo, BaseFileInfo containingFile, SourceInfo region, String name, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        super(containingFile, region);
        this.name = name;
        this.packageInfo = packageInfo;
        this.typeInterface = typeInterface;
        this.typeEnum = typeEnum;
        this.typeAnnotation = typeAnnotation;
        this.qualifiedName = this.calcQualifiedName();
    }

    protected BaseClassInfo(String name, String qualifiedName, boolean typeInterface, boolean typeEnum, boolean typeAnnotation, boolean testClass, SourceInfo region) {
        super(null, region);
        this.name = name;
        this.qualifiedName = qualifiedName;
        this.typeInterface = typeInterface;
        this.typeEnum = typeEnum;
        this.typeAnnotation = typeAnnotation;
        this.testClass = testClass;
    }

    private String calcQualifiedName() {
        return this.packageInfo == null ? null : (this.packageInfo.isDefault() ? this.getName() : this.packageInfo.getName() + "." + this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null && this.packageInfo != null) {
            this.qualifiedName = this.calcQualifiedName();
        }
        return this.qualifiedName;
    }

    public BasePackageInfo getPackage() {
        return this.packageInfo;
    }

    void setPackage(BasePackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public boolean isInterface() {
        return this.typeInterface;
    }

    public boolean isEnum() {
        return this.typeEnum;
    }

    public boolean isAnnotationType() {
        return this.typeAnnotation;
    }

    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public boolean isTestClass() {
        return this.testClass;
    }

    public ContextSet getContextFilter() {
        return this.getContainingFile().getContextFilter();
    }

    public String toString() {
        return "[" + this.getQualifiedName() + ",test=" + this.isTestClass() + ",if=" + this.isInterface() + ",enum=" + this.isEnum() + ",anno=" + this.isAnnotationType() + "]";
    }
}

