/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.JDKLogger;
import com.cenqua.clover.Log4JLogger;
import com.cenqua.clover.Logger;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class RecorderLogging {
    static /* synthetic */ Class class$com$cenqua$clover$Logger$Factory;

    public static void init() {
        try {
            String adapter = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("clover.logging.adapter");
                }

                @Override
                public /* synthetic */ Object run() {
                    return this.run();
                }
            });
            if (adapter != null && adapter.length() > 0) {
                if ("log4j".equalsIgnoreCase(adapter)) {
                    RecorderLogging.initLog4JLogging();
                } else if ("jdk".equalsIgnoreCase(adapter)) {
                    RecorderLogging.initJDKLogging();
                } else if (!"stderr".equals(adapter)) {
                    RecorderLogging.initCustomLogging(adapter);
                }
            }
        }
        catch (SecurityException e) {
            Logger.getInstance().info("Security exception trying to initialise Clover logging", e);
        }
    }

    private static void initLog4JLogging() {
        if (Log4JLogger.init()) {
            Logger.setFactory(new Log4JLogger.Factory());
        } else {
            Logger.getInstance().error("Unable to initialise Log4J Logger. Using default logger.");
        }
    }

    private static void initJDKLogging() {
        try {
            Class.forName("java.util.logging.Logger");
            Logger.setFactory(new JDKLogger.Factory());
        }
        catch (ClassNotFoundException e) {
            Logger.getInstance().error("Unable to initialise JDK Logger. Using default logger.");
        }
    }

    private static void initCustomLogging(String classname) {
        String errorMsg = "Unable to initialise Logger class '" + classname + "'. ";
        boolean successful = false;
        try {
            Class<?> loggerFactoryClass = Class.forName(classname);
            Class<?> clazz = class$com$cenqua$clover$Logger$Factory;
            if (clazz == null) {
                clazz = class$com$cenqua$clover$Logger$Factory = new Logger.Factory[0].getClass().getComponentType();
            }
            if (clazz.isAssignableFrom(loggerFactoryClass)) {
                Logger.Factory factory = (Logger.Factory)loggerFactoryClass.newInstance();
                Logger.setFactory(factory);
                successful = true;
            } else {
                Logger logger = Logger.getInstance();
                StringBuffer stringBuffer = new StringBuffer().append(errorMsg).append(" The class must be a subclass of ");
                Class<?> clazz2 = class$com$cenqua$clover$Logger$Factory;
                if (clazz2 == null) {
                    clazz2 = class$com$cenqua$clover$Logger$Factory = new Logger.Factory[0].getClass().getComponentType();
                }
                logger.error(stringBuffer.append(clazz2.getName()).append(". Using default logger.").toString());
            }
        }
        catch (ClassNotFoundException e) {
            errorMsg = errorMsg + "Class not found. ";
        }
        catch (ExceptionInInitializerError e) {
            errorMsg = errorMsg + "An error occured during class initialisation. ";
        }
        catch (IllegalAccessException e) {
            errorMsg = errorMsg + "An error occured during class initialisation. The class must provide a no-args public constructor. ";
        }
        catch (InstantiationException e) {
            errorMsg = errorMsg + "An error occured during class initialisation. The class must provide a no-args public constructor. ";
        }
        if (!successful) {
            errorMsg = errorMsg + " Using default logger";
            Logger.getInstance().error(errorMsg);
        }
    }
}

