/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

public class Color {
    static final String CSI = "\u001b[";
    static final String COLOR_PROPERTY = "ansi.color";
    private static final int BLACK = 30;
    private static final int RED = 31;
    private static final int GREEN = 32;
    private static final int YELLOW = 33;
    private static final int BLUE = 34;
    private static final int MAJENTA = 35;
    private static final int CYAN = 36;
    private static final int WHITE = 37;
    private static final int DEFAULT = 39;
    static final String RESET = "\u001b[1;0m";
    private static final String B = "0;1";
    private static final String I = "0;3";
    private static final String U = "0;4";
    private boolean bg = false;
    private String msg = "";
    private String category;
    private final StringBuffer formats = new StringBuffer();

    public static Color colorFor(String categoryName) {
        Color color = new Color();
        color.category = categoryName;
        return color;
    }

    public static Color make(String msg) {
        Color color = new Color();
        color.msg = msg;
        return color;
    }

    private Color() {
    }

    public Color b() {
        this.appendFmt(B);
        return this;
    }

    public Color i() {
        this.appendFmt(I);
        return this;
    }

    public Color u() {
        this.appendFmt(U);
        return this;
    }

    public Color black() {
        this.appendColor(30);
        return this;
    }

    public Color yellow() {
        this.appendColor(33);
        return this;
    }

    public Color blue() {
        this.appendColor(34);
        return this;
    }

    public Color majenta() {
        this.appendColor(35);
        return this;
    }

    public Color cyan() {
        this.appendColor(36);
        return this;
    }

    public Color white() {
        this.appendColor(37);
        return this;
    }

    public Color red() {
        this.appendColor(31);
        return this;
    }

    public Color green() {
        this.appendColor(32);
        return this;
    }

    public Color bg() {
        this.bg = true;
        return this;
    }

    private void appendColor(int color) {
        this.appendFmt(String.valueOf(color += this.bg ? 10 : 0));
        this.bg = false;
    }

    private void appendFmt(String fmt) {
        this.formats.append(CSI).append(fmt).append("m");
    }

    public String toString() {
        if (this.colorOn() && this.formats.length() > 0) {
            return this.formats.toString() + this.msg + RESET;
        }
        return this.msg;
    }

    private boolean colorOn() {
        return Boolean.getBoolean(COLOR_PROPERTY) || this.category != null && this.category.equalsIgnoreCase(System.getProperty(COLOR_PROPERTY));
    }

    public String getMsg() {
        return this.msg;
    }

    public String apply(String msg) {
        this.msg = msg;
        return this.toString();
    }
}

