/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.util.ByteSized;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;

public class CloverBitSet
extends clover.antlr.collections.impl.BitSet
implements ByteSized {
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final byte[] END_ZERO_TABLE = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    public CloverBitSet() {
    }

    public CloverBitSet(long[] bits) {
        super(bits);
    }

    public CloverBitSet(int nbits) {
        super(nbits);
    }

    public long[] getBits() {
        return this.bits;
    }

    public BitSet applyTo(BitSet to) {
        long[] masks = this.getBits();
        for (int i = 0; i < masks.length; ++i) {
            long mask = masks[i];
            if (mask == 0L) continue;
            int longOffset = 64 * i;
            for (int j = 0; j < 64; ++j) {
                long twiddle = 1L << j;
                if ((mask & twiddle) != twiddle) continue;
                to.set(longOffset + j);
            }
        }
        return to;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.bits.length);
        long[] arr$ = this.bits;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long bit = arr$[i$];
            out.writeLong(bit);
        }
    }

    public static CloverBitSet read(DataInput in) throws IOException {
        int numLongs = in.readInt();
        long[] data = new long[numLongs];
        for (int i = 0; i < numLongs; ++i) {
            data[i] = in.readLong();
        }
        return new CloverBitSet(data);
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex must be greater than or equal to 0: " + fromIndex);
        }
        int wordIndex = fromIndex >> 6;
        if (wordIndex >= this.bits.length) {
            return -1;
        }
        int testIndex = fromIndex & 0x3F;
        long unit = this.bits[wordIndex] >> testIndex;
        if (unit == 0L) {
            testIndex = 0;
        }
        while (unit == 0L && wordIndex < this.bits.length - 1) {
            unit = this.bits[++wordIndex];
        }
        if (unit == 0L) {
            return -1;
        }
        return wordIndex * 64 + (testIndex += CloverBitSet.countZeros(unit));
    }

    private static int countZeros(long val) {
        int asByte = (int)val & 0xFF;
        if (asByte != 0) {
            return END_ZERO_TABLE[asByte];
        }
        asByte = (int)(val >>> 8) & 0xFF;
        if (asByte != 0) {
            return END_ZERO_TABLE[asByte] + 8;
        }
        asByte = (int)(val >>> 16) & 0xFF;
        if (asByte != 0) {
            return END_ZERO_TABLE[asByte] + 16;
        }
        asByte = (int)(val >>> 24) & 0xFF;
        if (asByte != 0) {
            return END_ZERO_TABLE[asByte] + 24;
        }
        asByte = (int)(val >>> 32) & 0xFF;
        if (asByte != 0) {
            return END_ZERO_TABLE[asByte] + 32;
        }
        asByte = (int)(val >>> 40) & 0xFF;
        if (asByte != 0) {
            return END_ZERO_TABLE[asByte] + 40;
        }
        asByte = (int)(val >>> 48) & 0xFF;
        if (asByte != 0) {
            return END_ZERO_TABLE[asByte] + 48;
        }
        asByte = (int)(val >>> 56) & 0xFF;
        return END_ZERO_TABLE[asByte] + 56;
    }

    public static CloverBitSet forHits(int[] elements) {
        return CloverBitSet.forHits(new int[][]{elements}, elements.length);
    }

    public static CloverBitSet forHits(int[][] elements) {
        return CloverBitSet.forHits(elements, Integer.MAX_VALUE);
    }

    public static CloverBitSet forHits(int[][] elements, int maxElements) {
        CloverBitSet result = new CloverBitSet(elements.length == 0 ? 0 : elements.length * elements[0].length);
        int idx = 0;
        block0: for (int i = 0; i < elements.length; ++i) {
            int[] section = elements[i];
            int sectionLength = section.length;
            for (int j = 0; j < sectionLength; ++j) {
                if (section[j] != 0) {
                    result.add(idx);
                }
                if (++idx >= maxElements) break block0;
            }
        }
        return result;
    }

    public long sizeInBytes() {
        return this.bits.length << 3;
    }

    public boolean intersects(CloverBitSet other) {
        long[] otherBits = other.bits;
        long[] bits = this.bits;
        int reps = Math.min(bits.length, otherBits.length);
        for (int i = 0; i < reps; ++i) {
            if ((bits[i] & otherBits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public CloverBitSet and(CloverBitSet a) {
        CloverBitSet s = (CloverBitSet)this.clone();
        s.andInPlace(a);
        return s;
    }

    public CloverBitSet or(CloverBitSet a) {
        CloverBitSet s = (CloverBitSet)this.clone();
        s.orInPlace(a);
        return s;
    }

    public CloverBitSet flip(int startIdx, int endIdx) {
        CloverBitSet s = (CloverBitSet)this.clone();
        s.notInPlace(startIdx, endIdx - 1);
        return s;
    }

    public static BitSet fromIntArray(int[] data) {
        BitSet bitSet = new BitSet(data.length);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] <= 0) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public int length() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            long word = this.bits[i];
            if (word == 0L) continue;
            for (int bit = 63; bit >= 0; --bit) {
                if ((word & 1L << bit) == 0L) continue;
                return (i << 6) + bit + 1;
            }
        }
        return 0;
    }
}

