/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.remote;

import com.atlassian.clover.remote.Config;
import com.atlassian.clover.remote.DistributedConfig;
import com.atlassian.clover.remote.RecorderListener;
import com.atlassian.clover.remote.RecorderService;
import com.atlassian.clover.remote.RemoteServiceProvider;
import com.cenqua.clover.Logger;
import java.lang.reflect.InvocationTargetException;

public class RemoteFactory
implements RemoteServiceProvider {
    private static final RemoteFactory INSTANCE = new RemoteFactory();

    public static RemoteFactory getInstance() {
        return INSTANCE;
    }

    private RemoteFactory() {
    }

    public RecorderService createService(Config config) {
        String className = "com.atlassian.clover.remote.CajoTcpRecorderService";
        Logger.getInstance().verbose("Creating service com.atlassian.clover.remote.CajoTcpRecorderService for config: " + config.getName());
        RecorderService service = (RecorderService)RemoteFactory.instantiate("com.atlassian.clover.remote.CajoTcpRecorderService");
        service.init(config);
        return service;
    }

    public RecorderListener createListener(Config config) {
        String className = "com.atlassian.clover.remote.CajoTcpRecorderListener";
        Logger.getInstance().verbose("Creating listener com.atlassian.clover.remote.CajoTcpRecorderListener  for config: " + config.getName());
        RecorderListener listener = (RecorderListener)RemoteFactory.instantiate("com.atlassian.clover.remote.CajoTcpRecorderListener");
        listener.init(config);
        return listener;
    }

    public Config createConfig(String serverLocation) {
        return new DistributedConfig(serverLocation);
    }

    private static Object instantiate(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return RemoteFactory.instantiate(clazz);
        }
        catch (ClassNotFoundException e) {
            Logger.getInstance().error("Could not load class: " + className, e);
            return null;
        }
    }

    private static Object instantiate(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Can not instantiate a null class.");
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Logger.getInstance().error("Could not create: " + clazz, e);
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().error("Could not create: " + clazz, e);
        }
        catch (InvocationTargetException e) {
            Logger.getInstance().error("Could not create: " + clazz, e);
        }
        catch (InstantiationException e) {
            Logger.getInstance().error("Could not create: " + clazz, e);
        }
        return null;
    }
}

