/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.api.optimization;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.Enum_;
import com.cenqua.clover.Logger;
import com.cenqua.clover.test.optimization.Snapshot;
import java.io.File;

public class OptimizationOptions {
    private final boolean enabled;
    private final boolean minimize;
    private final TestSortOrder reorder;
    private final boolean debug;
    private final int maxCompilesBeforeStaleSnapshot;
    private final Logger logger;
    private final String optimizableName;
    private final File snapshot;
    private final String initString;

    private OptimizationOptions(Builder builder) {
        this.enabled = builder.enabled;
        this.minimize = builder.minimize;
        this.reorder = builder.reorder;
        this.debug = builder.debugFlag;
        this.maxCompilesBeforeStaleSnapshot = builder.maxCompilesBeforeStaleSnapshot;
        this.logger = builder.logger;
        this.optimizableName = builder.optimizableName;
        this.snapshot = builder.snapshot;
        this.initString = builder.initString;
    }

    public boolean isReorderFailfast() {
        return this.getReorder() == TestSortOrder.FAILFAST;
    }

    public boolean isReordering() {
        return this.getReorder() != TestSortOrder.NONE;
    }

    public boolean isReorderRandomly() {
        return this.getReorder() == TestSortOrder.RANDOM;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public String getOptimizableName() {
        return this.optimizableName;
    }

    public TestSortOrder getReorder() {
        return this.reorder;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getMaxCompilesBeforeStaleSnapshot() {
        return this.maxCompilesBeforeStaleSnapshot;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getInitString() {
        return this.initString;
    }

    public File getSnapshotFile() {
        return this.snapshot;
    }

    public String toString() {
        return "OptimizationOptions{enabled=" + this.enabled + ", minimize=" + this.minimize + ", reorder=" + this.reorder + ", debug=" + this.debug + ", maxCompilesBeforeStaleSnapshot=" + this.maxCompilesBeforeStaleSnapshot + ", optimizableName='" + this.optimizableName + '\'' + ", initString='" + this.initString + '\'' + ", snapshot=" + this.snapshot + '}';
    }

    public static final class Builder {
        private boolean enabled;
        private boolean minimize;
        private TestSortOrder reorder;
        private boolean debugFlag;
        private int maxCompilesBeforeStaleSnapshot;
        private Logger logger;
        private String optimizableName;
        private File snapshot;
        private String initString;

        public Builder() {
            this.enabled(true).minimize(true).reorderFailfast().optimizableName("test").maxCompilesBeforeStaleSnapshot(10).debug(false);
        }

        public Builder snapshot(File snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder initString(String initString) {
            this.initString = initString;
            return this;
        }

        public Builder initStringAndSnapshotFrom(String initString) {
            return this.initString(initString).snapshot(Snapshot.fileForInitString(initString));
        }

        public Builder optimizableName(String name) {
            this.optimizableName = name;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder reorderFailfast() {
            this.reorder = TestSortOrder.FAILFAST;
            return this;
        }

        public Builder dontReorder() {
            this.reorder = TestSortOrder.NONE;
            return this;
        }

        public Builder reorderRandomly() {
            this.reorder = TestSortOrder.RANDOM;
            return this;
        }

        public Builder reorder(TestSortOrder reorder) {
            this.reorder = reorder;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debugFlag = debug;
            return this;
        }

        public Builder maxCompilesBeforeStaleSnapshot(int maxCompilesBeforeStaleSnapshot) {
            this.maxCompilesBeforeStaleSnapshot = maxCompilesBeforeStaleSnapshot;
            return this;
        }

        public OptimizationOptions build() {
            return new OptimizationOptions(this);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TestSortOrder
    extends Enum_<TestSortOrder> {
        public static final TestSortOrder NONE = new TestSortOrder("NONE", 0, 0);
        public static final TestSortOrder FAILFAST = new TestSortOrder("FAILFAST", 1, 1);
        public static final TestSortOrder RANDOM = new TestSortOrder("RANDOM", 2, 2);
        private final int integer;
        private static final /* synthetic */ TestSortOrder[] $VALUES;
        static /* synthetic */ Class class$com$atlassian$clover$api$optimization$OptimizationOptions$TestSortOrder;

        public static final TestSortOrder[] values() {
            return (TestSortOrder[])$VALUES.clone();
        }

        public static TestSortOrder valueOf(String name) {
            Class<?> clazz = class$com$atlassian$clover$api$optimization$OptimizationOptions$TestSortOrder;
            if (clazz == null) {
                clazz = class$com$atlassian$clover$api$optimization$OptimizationOptions$TestSortOrder = new TestSortOrder[0].getClass().getComponentType();
            }
            return (TestSortOrder)Enum_.valueOf(clazz, name);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        private TestSortOrder(int integer) {
            super((String)n, n2);
            this.integer = integer;
        }

        public int asInteger() {
            return this.integer;
        }

        static {
            $VALUES = new TestSortOrder[]{NONE, FAILFAST, RANDOM};
        }
    }
}

