/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.GenericArrayTypeImpl;
import clover.com.google.gson.ParameterizedTypeImpl;
import clover.com.google.gson.Preconditions;
import clover.com.google.gson.TypeInfo;
import clover.com.google.gson.TypeInfoArray;
import clover.com.google.gson.TypeUtils;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Class;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.reflect.GenericArrayType_;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.reflect.ParameterizedType_;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.reflect.TypeVariable_;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.reflect.WildcardType_;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.reflect._Field;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeInfoFactory {
    private TypeInfoFactory() {
    }

    public static TypeInfoArray getTypeInfoForArray(Object type) {
        Preconditions.checkArgument(TypeUtils.isArray(type));
        return new TypeInfoArray(type);
    }

    public static TypeInfo getTypeInfoForField(Field f, Object typeDefiningF) {
        Class<?> classDefiningF = TypeUtils.toRawClass(typeDefiningF);
        Object type = _Field.getGenericType(f);
        Object actualType = TypeInfoFactory.getActualType(type, typeDefiningF, classDefiningF);
        return new TypeInfo(actualType);
    }

    private static Object getActualType(Object typeToEvaluate, Object parentType, Class<?> rawParentClass) {
        if (typeToEvaluate instanceof Class) {
            return typeToEvaluate;
        }
        if (typeToEvaluate instanceof ParameterizedType_) {
            ParameterizedType_ castedType = (ParameterizedType_)typeToEvaluate;
            Object owner = castedType.getOwnerType();
            Object[] actualTypeParameters = TypeInfoFactory.extractRealTypes(castedType.getActualTypeArguments(), parentType, rawParentClass);
            Object rawType = castedType.getRawType();
            return new ParameterizedTypeImpl(rawType, actualTypeParameters, owner);
        }
        if (typeToEvaluate instanceof GenericArrayType_) {
            Object actualType;
            GenericArrayType_ castedType = (GenericArrayType_)typeToEvaluate;
            Object componentType = castedType.getGenericComponentType();
            if (componentType.equals(actualType = TypeInfoFactory.getActualType(componentType, parentType, rawParentClass))) {
                return castedType;
            }
            if (actualType instanceof Class) {
                return TypeUtils.wrapWithArray(TypeUtils.toRawClass(actualType));
            }
            return new GenericArrayTypeImpl(actualType);
        }
        if (typeToEvaluate instanceof TypeVariable_) {
            if (parentType instanceof ParameterizedType_) {
                TypeVariable_ fieldTypeVariable = (TypeVariable_)typeToEvaluate;
                TypeVariable_[] classTypeVariables = _Class.getTypeParameters(rawParentClass);
                ParameterizedType_ objParameterizedType = (ParameterizedType_)parentType;
                int indexOfActualTypeArgument = TypeInfoFactory.getIndex(classTypeVariables, fieldTypeVariable);
                Object[] actualTypeArguments = objParameterizedType.getActualTypeArguments();
                return actualTypeArguments[indexOfActualTypeArgument];
            }
            throw new UnsupportedOperationException(new StringBuffer().append("Expecting parameterized type, got ").append(parentType).append(".\n Are you missing the use of TypeToken idiom?\n See ").append("http://sites.google.com/site/gson/gson-user-guide#TOC-Serializing-and-Deserializing-Gener").toString());
        }
        if (typeToEvaluate instanceof WildcardType_) {
            WildcardType_ castedType = (WildcardType_)typeToEvaluate;
            return TypeInfoFactory.getActualType(castedType.getUpperBounds()[0], parentType, rawParentClass);
        }
        throw new IllegalArgumentException(new StringBuffer().append("Type '").append(typeToEvaluate).append("' is not a Class, ").append("ParameterizedType, GenericArrayType or TypeVariable. Can't extract type.").toString());
    }

    private static Object[] extractRealTypes(Object[] actualTypeArguments, Object parentType, Class<?> rawParentClass) {
        Preconditions.checkNotNull(actualTypeArguments);
        Object[] retTypes = new Object[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            retTypes[i] = TypeInfoFactory.getActualType(actualTypeArguments[i], parentType, rawParentClass);
        }
        return retTypes;
    }

    private static int getIndex(TypeVariable_<?>[] types, TypeVariable_<?> type) {
        for (int i = 0; i < types.length; ++i) {
            if (!type.equals(types[i])) continue;
            return i;
        }
        throw new IllegalStateException("How can the type variable not be present in the class declaration!");
    }
}

