/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.ExclusionStrategy;
import clover.com.google.gson.MemoryRefStack;
import clover.com.google.gson.Preconditions;
import clover.com.google.gson.TypeInfo;
import clover.com.google.gson.TypeInfoFactory;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Class;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectNavigator {
    private final ExclusionStrategy exclusionStrategy;
    private final MemoryRefStack<Object> ancestors;
    private final Object obj;
    private final Object objType;
    static /* synthetic */ Class class$java$lang$Object;

    ObjectNavigator(Object obj, Object objType, ExclusionStrategy exclusionStrategy, MemoryRefStack<Object> ancestors) {
        Preconditions.checkNotNull(exclusionStrategy);
        Preconditions.checkNotNull(ancestors);
        this.obj = obj;
        this.objType = objType;
        this.exclusionStrategy = exclusionStrategy;
        this.ancestors = ancestors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor visitor) {
        block11: {
            boolean visitedWithCustomHandler = visitor.visitUsingCustomHandler(this.obj, this.objType);
            if (!visitedWithCustomHandler) {
                Object objectToVisit;
                Object object = objectToVisit = this.obj == null ? visitor.getTarget() : this.obj;
                if (objectToVisit == null) {
                    return;
                }
                TypeInfo objTypeInfo = new TypeInfo(this.objType);
                if (this.exclusionStrategy.shouldSkipClass(objTypeInfo.getRawClass())) {
                    return;
                }
                if (this.ancestors.contains(objectToVisit)) {
                    throw new IllegalStateException(new StringBuffer().append("Circular reference found: ").append(objectToVisit).toString());
                }
                this.ancestors.push(objectToVisit);
                try {
                    if (objTypeInfo.isArray()) {
                        visitor.visitArray(objectToVisit, this.objType);
                        break block11;
                    }
                    visitor.startVisitingObject(objectToVisit);
                    for (Class<?> curr = objTypeInfo.getRawClass(); curr != null; curr = curr.getSuperclass()) {
                        Class<?> clazz = class$java$lang$Object;
                        if (clazz == null) {
                            clazz = new Object[0].getClass().getComponentType();
                        }
                        if (!curr.equals(clazz)) {
                            if (_Class.isSynthetic(curr)) continue;
                            this.navigateClassFields(objectToVisit, curr, visitor);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.ancestors.pop();
                }
            }
        }
    }

    private void navigateClassFields(Object obj, Class<?> clazz, Visitor visitor) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            boolean visitedWithCustomHandler;
            TypeInfo fieldTypeInfo = TypeInfoFactory.getTypeInfoForField((Field)f, this.objType);
            Object actualTypeOfField = fieldTypeInfo.getActualType();
            if (this.exclusionStrategy.shouldSkipField((Field)f) || (visitedWithCustomHandler = visitor.visitFieldUsingCustomHandler((Field)f, actualTypeOfField, obj))) continue;
            if (fieldTypeInfo.isArray()) {
                visitor.visitArrayField((Field)f, actualTypeOfField, obj);
                continue;
            }
            visitor.visitObjectField((Field)f, actualTypeOfField, obj);
        }
    }

    public static interface Visitor {
        public void startVisitingObject(Object var1);

        public void visitArray(Object var1, Object var2);

        public void visitObjectField(Field var1, Object var2, Object var3);

        public void visitArrayField(Field var1, Object var2, Object var3);

        public boolean visitUsingCustomHandler(Object var1, Object var2);

        public boolean visitFieldUsingCustomHandler(Field var1, Object var2, Object var3);

        public Object getTarget();
    }
}

