/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.InstanceCreator;
import clover.com.google.gson.ObjectConstructor;
import clover.com.google.gson.ParameterizedTypeHandlerMap;
import clover.com.google.gson.TypeInfo;
import clover.com.google.gson.TypeUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MappedObjectConstructor
implements ObjectConstructor {
    private static final Logger log;
    private final ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreatorMap;
    static /* synthetic */ Class class$clover$com$google$gson$MappedObjectConstructor;

    public MappedObjectConstructor(ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreators) {
        this.instanceCreatorMap = instanceCreators;
    }

    @Override
    public <T> T construct(Object typeOfT) {
        InstanceCreator<?> creator = this.instanceCreatorMap.getHandlerFor(typeOfT);
        if (creator != null) {
            return (T)creator.createInstance(typeOfT);
        }
        return this.constructWithNoArgConstructor(typeOfT);
    }

    @Override
    public Object constructArray(Object type, int length) {
        return Array.newInstance(TypeUtils.toRawClass(type), length);
    }

    private <T> T constructWithNoArgConstructor(Object typeOfT) {
        try {
            Constructor<T> constructor = this.getNoArgsConstructor(typeOfT);
            if (constructor == null) {
                throw new RuntimeException(new StringBuffer().append("No-args constructor for ").append(typeOfT).append(" does not exist. ").append("Register an InstanceCreator with Gson for this type to fix this problem.").toString());
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(new StringBuffer().append("Unable to invoke no-args constructor for ").append(typeOfT).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(new StringBuffer().append("Unable to invoke no-args constructor for ").append(typeOfT).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new StringBuffer().append("Unable to invoke no-args constructor for ").append(typeOfT).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), e);
        }
    }

    private <T> Constructor<T> getNoArgsConstructor(Object typeOfT) {
        TypeInfo typeInfo = new TypeInfo(typeOfT);
        Class<?> clazz = typeInfo.getRawClass();
        AccessibleObject[] declaredConstructors = clazz.getDeclaredConstructors();
        AccessibleObject.setAccessible(declaredConstructors, true);
        for (AccessibleObject constructor : declaredConstructors) {
            if (((Constructor)constructor).getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    <T> void register(Object typeOfT, InstanceCreator<? extends T> creator) {
        if (this.instanceCreatorMap.hasSpecificHandlerFor(typeOfT)) {
            log.log(Level.WARNING, new StringBuffer().append("Overriding the existing InstanceCreator for ").append(typeOfT).toString());
        }
        this.instanceCreatorMap.register(typeOfT, creator);
    }

    public String toString() {
        return this.instanceCreatorMap.toString();
    }

    static {
        Class<?> clazz = class$clover$com$google$gson$MappedObjectConstructor;
        if (clazz == null) {
            clazz = class$clover$com$google$gson$MappedObjectConstructor = new MappedObjectConstructor[0].getClass().getComponentType();
        }
        log = Logger.getLogger(clazz.getName());
    }
}

