/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonElement;
import clover.com.google.gson.Preconditions;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Appendable;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Boolean;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private static final Class<?>[] PRIMITIVE_TYPES;
    private Object value;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    public JsonPrimitive(Boolean bool) {
        this.value = bool;
    }

    public JsonPrimitive(Number number) {
        this.value = number;
    }

    public JsonPrimitive(String string) {
        this.value = string;
    }

    public JsonPrimitive(Character c) {
        this.value = String.valueOf(c);
    }

    JsonPrimitive(Object primitive) {
        this.setValue(primitive);
    }

    void setValue(Object primitive) {
        if (primitive instanceof Character) {
            char c = ((Character)primitive).charValue();
            this.value = String.valueOf(c);
        } else {
            Preconditions.checkArgument(primitive instanceof Number || JsonPrimitive.isPrimitiveOrString(primitive));
            this.value = primitive;
        }
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    Boolean getAsBooleanWrapper() {
        return (Boolean)this.value;
    }

    public boolean getAsBoolean() {
        if (this.isBoolean()) {
            return this.getAsBooleanWrapper();
        }
        return _Boolean.parseBoolean(this.getAsString());
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public Number getAsNumber() {
        return (Number)this.value;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public String getAsString() {
        if (this.isNumber()) {
            return this.getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return this.getAsBooleanWrapper().toString();
        }
        return (String)this.value;
    }

    public double getAsDouble() {
        if (this.isNumber()) {
            return this.getAsNumber().doubleValue();
        }
        return Double.parseDouble(this.getAsString());
    }

    public BigDecimal getAsBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(this.value.toString());
    }

    public BigInteger getAsBigInteger() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        return new BigInteger(this.value.toString());
    }

    public float getAsFloat() {
        if (this.isNumber()) {
            return this.getAsNumber().floatValue();
        }
        return Float.parseFloat(this.getAsString());
    }

    public long getAsLong() {
        if (this.isNumber()) {
            return this.getAsNumber().longValue();
        }
        return Long.parseLong(this.getAsString());
    }

    public short getAsShort() {
        if (this.isNumber()) {
            return this.getAsNumber().shortValue();
        }
        return Short.parseShort(this.getAsString());
    }

    public int getAsInt() {
        if (this.isNumber()) {
            return this.getAsNumber().intValue();
        }
        return Integer.parseInt(this.getAsString());
    }

    public byte getAsByte() {
        if (this.isNumber()) {
            return this.getAsNumber().byteValue();
        }
        return Byte.parseByte(this.getAsString());
    }

    public char getAsCharacter() {
        return this.getAsString().charAt(0);
    }

    Object getAsObject() {
        return this.value;
    }

    protected void toString(Object sb) throws IOException {
        if (this.value instanceof String) {
            _Appendable.append(sb, '\"');
            _Appendable.append(sb, (String)this.value);
            _Appendable.append(sb, '\"');
        } else {
            _Appendable.append(sb, this.value.toString());
        }
    }

    private static boolean isPrimitiveOrString(Object target) {
        if (target instanceof String) {
            return true;
        }
        Class<?> classOfPrimitive = target.getClass();
        Class<?>[] arr$ = PRIMITIVE_TYPES;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Class<?> standardPrimitive = arr$[i$];
            if (!standardPrimitive.isAssignableFrom(classOfPrimitive)) continue;
            return true;
        }
        return false;
    }

    static {
        Class<?> clazz;
        Class clazz2;
        Class clazz3;
        Class clazz4;
        Class clazz5;
        Class clazz6;
        Class clazz7;
        Class[] classArray = new Class[16];
        classArray[0] = Integer.TYPE;
        classArray[1] = Long.TYPE;
        classArray[2] = Short.TYPE;
        classArray[3] = Float.TYPE;
        classArray[4] = Double.TYPE;
        classArray[5] = Byte.TYPE;
        classArray[6] = Boolean.TYPE;
        classArray[7] = Character.TYPE;
        Class clazz8 = class$java$lang$Integer;
        if (clazz8 == null) {
            clazz8 = classArray[8] = (class$java$lang$Integer = new Integer[0].getClass().getComponentType());
        }
        if ((clazz7 = class$java$lang$Long) == null) {
            clazz7 = classArray[9] = (class$java$lang$Long = new Long[0].getClass().getComponentType());
        }
        if ((clazz6 = class$java$lang$Short) == null) {
            clazz6 = classArray[10] = (class$java$lang$Short = new Short[0].getClass().getComponentType());
        }
        if ((clazz5 = class$java$lang$Float) == null) {
            clazz5 = classArray[11] = (class$java$lang$Float = new Float[0].getClass().getComponentType());
        }
        if ((clazz4 = class$java$lang$Double) == null) {
            clazz4 = classArray[12] = (class$java$lang$Double = new Double[0].getClass().getComponentType());
        }
        if ((clazz3 = class$java$lang$Byte) == null) {
            clazz3 = classArray[13] = (class$java$lang$Byte = new Byte[0].getClass().getComponentType());
        }
        if ((clazz2 = class$java$lang$Boolean) == null) {
            clazz2 = classArray[14] = (class$java$lang$Boolean = new Boolean[0].getClass().getComponentType());
        }
        if ((clazz = class$java$lang$Character) == null) {
            clazz = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        classArray[15] = clazz;
        PRIMITIVE_TYPES = classArray;
    }
}

