/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonDeserializationContext;
import clover.com.google.gson.JsonDeserializer;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonParseException;
import clover.com.google.gson.Preconditions;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsonDeserializerExceptionWrapper<T>
implements JsonDeserializer<T> {
    private final JsonDeserializer<T> delegate;

    JsonDeserializerExceptionWrapper(JsonDeserializer<T> delegate) {
        Preconditions.checkNotNull(delegate);
        this.delegate = delegate;
    }

    @Override
    public T deserialize(JsonElement json, Object typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return this.delegate.deserialize(json, typeOfT, context);
        }
        catch (JsonParseException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer errorMsg = new StringBuffer().append("The JsonDeserializer ").append(this.delegate).append(" failed to deserialized json object ").append(json).append(" given the type ").append(typeOfT);
            throw new JsonParseException(errorMsg.toString(), e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

