/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.logging.Logger;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static Properties loadPropertyFile(File propFile, Properties baseProps) throws IOException {
        return PropertyUtils.loadPropertyFile(propFile, baseProps, null);
    }

    public static Properties loadPropertyFile(File propFile, Properties baseProps, Logger logger) throws IOException {
        if (!propFile.exists()) {
            throw new FileNotFoundException(propFile.toString());
        }
        Properties fileProps = new Properties();
        InputStream inStream = Files.newInputStream(propFile.toPath(), new OpenOption[0]);
        Object object = null;
        try {
            fileProps.load(inStream);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (inStream != null) {
                if (object != null) {
                    try {
                        inStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    inStream.close();
                }
            }
        }
        Properties combinedProps = new Properties();
        combinedProps.putAll((Map<?, ?>)(baseProps == null ? new Properties() : baseProps));
        combinedProps.putAll((Map<?, ?>)fileProps);
        for (Object e : fileProps.keySet()) {
            String k = (String)e;
            String propValue = PropertyUtils.getPropertyValue(k, combinedProps, logger);
            fileProps.setProperty(k, propValue);
        }
        return fileProps;
    }

    public static Properties loadPropertyFile(File propfile, boolean fail, boolean useSystemProps) throws IOException {
        return PropertyUtils.loadPropertyFile(propfile, fail, useSystemProps, null);
    }

    public static Properties loadPropertyFile(File propfile, boolean fail, boolean useSystemProps, Logger logger) throws IOException {
        Properties resolvedProps;
        Properties baseProps;
        block4: {
            baseProps = new Properties();
            if (useSystemProps) {
                baseProps.putAll((Map<?, ?>)System.getProperties());
            }
            resolvedProps = new Properties();
            try {
                resolvedProps.putAll((Map<?, ?>)PropertyUtils.loadPropertyFile(propfile, baseProps, logger));
            }
            catch (FileNotFoundException e) {
                if (!fail) break block4;
                throw new FileNotFoundException(propfile.toString());
            }
        }
        if (useSystemProps) {
            resolvedProps.putAll((Map<?, ?>)baseProps);
        }
        return resolvedProps;
    }

    private static String getPropertyValue(String k, Properties p, Logger logger) {
        int idx;
        String v;
        LinkedList<String> valueChain = new LinkedList<String>();
        valueChain.add(k);
        String defaultValue = v = p.getProperty(k);
        String ret = "";
        while ((idx = v.indexOf("${")) >= 0) {
            ret = ret + v.substring(0, idx);
            int idx2 = (v = v.substring(idx + 2)).indexOf(125);
            if (idx2 < 0) break;
            String nk = v.substring(0, idx2);
            v = v.substring(idx2 + 1);
            String nv = p.getProperty(nk);
            if (valueChain.contains(nk)) {
                if (logger != null) {
                    PropertyUtils.logCircularDetection(valueChain, nk, logger);
                }
                return defaultValue;
            }
            valueChain.add(nk);
            if (nv == null && !StringUtils.isEmpty((String)nk)) {
                nv = System.getProperty(nk);
            }
            if (nv == null || nv.equals(k) || k.equals(nk)) {
                ret = ret + "${" + nk + "}";
                continue;
            }
            v = nv + v;
        }
        return ret + v;
    }

    private static void logCircularDetection(List<String> valueChain, String nk, Logger logger) {
        StringBuilder sb = new StringBuilder("Circular reference between properties detected: ");
        for (String key : valueChain) {
            sb.append(key).append(" => ");
        }
        sb.append(nk);
        logger.warn(sb.toString());
    }
}

