/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy;

import com.google.common.base.Strings;
import java.io.File;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.nexus.maven.staging.deploy.AbstractDeployMojo;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.FinalizeDeployRequest;

@Mojo(name="deploy-staged-repository", requiresProject=false, requiresDirectInvocation=true, requiresOnline=true, threadSafe=true)
public class DeployRepositoryMojo
extends AbstractDeployMojo {
    @Parameter(property="repositoryDirectory", required=true)
    private File repositoryDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.failIfOffline();
        if (this.repositoryDirectory == null) {
            throw new MojoFailureException("Staged repository path is not set, use \"-DrepositoryDirectory=/some/path\" on CLI to set it.");
        }
        if (!this.repositoryDirectory.isDirectory()) {
            throw new MojoFailureException("Staged repository path is not pointing to an existing (or readable?) directory! Path set is " + this.repositoryDirectory.getAbsolutePath());
        }
        if (Strings.isNullOrEmpty((String)this.getStagingProfileId())) {
            throw new MojoFailureException("Stage profile ID is not set, use \"-DstagingProfileId=XXXX\" on CLI to set it.");
        }
        if (this.isThisLastProjectWithThisMojoInExecution()) {
            try {
                DeployStrategy deployStrategy = this.getDeployStrategy("image");
                FinalizeDeployRequest request = new FinalizeDeployRequest(this.getMavenSession(), this.buildParameters());
                deployStrategy.finalizeDeploy(request);
            }
            catch (ArtifactDeploymentException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    @Override
    protected File getStagingDirectoryRoot() {
        return this.repositoryDirectory;
    }
}

