/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.client.internal.util.Check;

public class StagingRuleFailures {
    private final String repositoryId;
    private final List<RuleFailure> failures;

    public StagingRuleFailures(String repositoryId, Collection<RuleFailure> failures) {
        this.repositoryId = Check.notBlank((String)repositoryId, (String)"repositoryId");
        this.failures = Collections.unmodifiableList(new ArrayList<RuleFailure>(failures));
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public List<RuleFailure> getFailures() {
        return this.failures;
    }

    public static class RuleFailure {
        private final String ruleName;
        private final List<String> messages;

        public RuleFailure(String ruleName, List<String> messages) {
            this.ruleName = Check.notBlank((String)ruleName, (String)"ruleName");
            ArrayList<String> msgs = new ArrayList<String>();
            if (messages != null) {
                msgs.addAll(messages);
            }
            this.messages = Collections.unmodifiableList(msgs);
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public List<String> getMessages() {
            return this.messages;
        }
    }
}

