/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.zapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.spice.zapper.IOSource;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.hash.Hash;
import org.sonatype.spice.zapper.hash.HashUtils;
import org.sonatype.spice.zapper.internal.PayloadCreator;
import org.sonatype.spice.zapper.internal.Segment;
import org.sonatype.spice.zapper.internal.SegmentPayload;
import org.sonatype.spice.zapper.internal.Transfer;
import org.sonatype.spice.zapper.internal.TransferIdentifier;
import org.sonatype.spice.zapper.internal.zapper.ZapperPayload;

public class ZapperPayloadCreator
implements PayloadCreator {
    private final Parameters parameters;

    public ZapperPayloadCreator(Parameters parameters) {
        this.parameters = parameters;
    }

    public int createPayloads(Transfer transfer, IOSource source, String remoteUrl) throws IOException {
        List<Segment> segments = transfer.getSegments();
        ArrayList<SegmentPayload> payloads = new ArrayList<SegmentPayload>(segments.size());
        for (Segment segment : segments) {
            payloads.add(this.createPayload(transfer, segment, source, remoteUrl));
        }
        transfer.setPayloads(payloads);
        return payloads.size();
    }

    protected ZapperPayload createPayload(Transfer transfer, Segment segment, IOSource source, String remoteUrl) throws IOException {
        Hash segmentHash = HashUtils.getDigest(this.parameters.getHashAlgorithm(), source.readSegment((Path)segment.getZFile().getIdentifier(), segment));
        return new ZapperPayload((TransferIdentifier)transfer.getIdentifier(), (Path)segment.getZFile().getIdentifier(), segment, source, this.parameters.getHashAlgorithm(), segmentHash, this.parameters.getCodecSelector().selectCodecs(segment.getZFile()));
    }
}

