/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.wholefile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.spice.zapper.IOSource;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.internal.PayloadCreator;
import org.sonatype.spice.zapper.internal.Segment;
import org.sonatype.spice.zapper.internal.SegmentPayload;
import org.sonatype.spice.zapper.internal.Transfer;
import org.sonatype.spice.zapper.internal.TransferIdentifier;

public class WholeZFilePayloadCreator
implements PayloadCreator {
    private final Parameters parameters;

    public WholeZFilePayloadCreator(Parameters parameters) {
        this.parameters = parameters;
    }

    public int createPayloads(Transfer transfer, IOSource source, String remoteUrl) throws IOException {
        List<Segment> segments = transfer.getSegments();
        ArrayList<SegmentPayload> payloads = new ArrayList<SegmentPayload>(segments.size());
        for (Segment segment : segments) {
            payloads.add(this.createPayload(transfer, segment, source, remoteUrl));
        }
        transfer.setPayloads(payloads);
        return payloads.size();
    }

    protected SegmentPayload createPayload(Transfer transfer, Segment segment, IOSource source, String remoteUrl) throws IOException {
        return new SegmentPayload((TransferIdentifier)transfer.getIdentifier(), (Path)segment.getZFile().getIdentifier(), segment, source, segment.getZFile().getHash(), this.parameters.getCodecSelector().selectCodecs(segment.getZFile()));
    }
}

