/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest.jersey;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.ApacheHttpClient4Config;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import com.thoughtworks.xstream.XStream;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.client.core.Condition;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.condition.NexusStatusConditions;
import org.sonatype.nexus.client.core.spi.SubsystemProvider;
import org.sonatype.nexus.client.internal.rest.NexusXStreamFactory;
import org.sonatype.nexus.client.internal.rest.XStreamXmlProvider;
import org.sonatype.nexus.client.internal.util.Version;
import org.sonatype.nexus.client.rest.AuthenticationInfo;
import org.sonatype.nexus.client.rest.BaseUrl;
import org.sonatype.nexus.client.rest.ConnectionInfo;
import org.sonatype.nexus.client.rest.NexusClientFactory;
import org.sonatype.nexus.client.rest.ProxyInfo;
import org.sonatype.nexus.client.rest.UsernamePasswordAuthenticationInfo;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.sisu.siesta.client.filters.RequestFilters;

public class NexusClientFactoryImpl
implements NexusClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NexusClientFactoryImpl.class);
    private static final MediaType APPLICATION_XML_UTF8_TYPE = MediaType.valueOf((String)"application/xml; charset=UTF-8");
    private final Condition connectionCondition;
    private final List<SubsystemProvider> subsystemProviders;

    public NexusClientFactoryImpl(List<SubsystemProvider> subsystemProviders) {
        this(NexusStatusConditions.anyModern(), subsystemProviders);
    }

    public NexusClientFactoryImpl(Condition connectionCondition, List<SubsystemProvider> subsystemProviders) {
        this.connectionCondition = (Condition)Preconditions.checkNotNull((Object)connectionCondition, (Object)"connectionCondition");
        this.subsystemProviders = (List)Preconditions.checkNotNull(subsystemProviders, (Object)"subsystemProviders");
    }

    @Override
    public final NexusClient createFor(BaseUrl baseUrl) {
        return this.createFor(baseUrl, null);
    }

    @Override
    public final NexusClient createFor(BaseUrl baseUrl, AuthenticationInfo authenticationInfo) {
        return this.createFor(new ConnectionInfo(baseUrl, authenticationInfo, null));
    }

    @Override
    public final NexusClient createFor(ConnectionInfo connectionInfo) {
        XStream xstream = new NexusXStreamFactory().createAndConfigureForXml();
        return new JerseyNexusClient(this.connectionCondition, this.subsystemProviders, connectionInfo, xstream, (Client)this.doCreateHttpClientFor(connectionInfo, xstream), APPLICATION_XML_UTF8_TYPE);
    }

    protected ApacheHttpClient4 doCreateHttpClientFor(ConnectionInfo connectionInfo, XStream xstream) {
        AllowAllHostnameVerifier hostnameVerifier;
        Object trustStrategy;
        DefaultApacheHttpClient4Config config = new DefaultApacheHttpClient4Config();
        config.getSingletons().add(new XStreamXmlProvider(xstream, APPLICATION_XML_UTF8_TYPE));
        config.getProperties().put("com.sun.jersey.client.property.followRedirects", Boolean.FALSE);
        this.applyAuthenticationIfAny(connectionInfo, (ApacheHttpClient4Config)config);
        this.applyProxyIfAny(connectionInfo, (ApacheHttpClient4Config)config);
        config.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault()));
        ApacheHttpClient4 client = ApacheHttpClient4.create((ClientConfig)config);
        client.getClientHandler().getHttpClient().getParams().setParameter("http.useragent", (Object)("Nexus-Client/" + this.discoverClientVersion()));
        switch (connectionInfo.getSslCertificateValidation()) {
            case NONE: {
                trustStrategy = new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                };
                break;
            }
            case LAX: {
                trustStrategy = new TrustSelfSignedStrategy();
                break;
            }
            default: {
                trustStrategy = null;
            }
        }
        switch (connectionInfo.getSslCertificateHostnameValidation()) {
            case NONE: {
                hostnameVerifier = new AllowAllHostnameVerifier();
                break;
            }
            case STRICT: {
                hostnameVerifier = new StrictHostnameVerifier();
                break;
            }
            default: {
                hostnameVerifier = new BrowserCompatHostnameVerifier();
            }
        }
        try {
            SSLSocketFactory ssf = new SSLSocketFactory((TrustStrategy)trustStrategy, (X509HostnameVerifier)hostnameVerifier);
            Scheme tweakedHttpsScheme = new Scheme("https", 443, (SchemeSocketFactory)ssf);
            client.getClientHandler().getHttpClient().getConnectionManager().getSchemeRegistry().register(tweakedHttpsScheme);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        this.enforceProxyUri((ApacheHttpClient4Config)config, client);
        if (LOG.isDebugEnabled()) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
        client.addFilter((ClientFilter)new RequestFilters());
        return client;
    }

    protected String discoverClientVersion() {
        return Version.readVersion("META-INF/maven/org.sonatype.nexus/nexus-client-core/pom.properties", "unknown");
    }

    private void enforceProxyUri(ApacheHttpClient4Config config, ApacheHttpClient4 client) {
        Object proxyProperty = config.getProperties().get("com.sun.jersey.impl.client.httpclient.proxyURI");
        if (proxyProperty != null) {
            URI uri = NexusClientFactoryImpl.getProxyUri(proxyProperty);
            HttpHost proxy = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            client.getClientHandler().getHttpClient().getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ClientHandlerException("The proxy URI (com.sun.jersey.impl.client.httpclient.proxyURI) property MUST be an instance of String or URI");
    }

    protected void applyAuthenticationIfAny(ConnectionInfo connectionInfo, ApacheHttpClient4Config config) {
        if (connectionInfo.getAuthenticationInfo() != null) {
            if (connectionInfo.getAuthenticationInfo() instanceof UsernamePasswordAuthenticationInfo) {
                UsernamePasswordAuthenticationInfo upinfo = (UsernamePasswordAuthenticationInfo)connectionInfo.getAuthenticationInfo();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(upinfo.getUsername(), upinfo.getPassword()));
                config.getProperties().put("com.sun.jersey.impl.client.httpclient.credentialsProvider", credentialsProvider);
                config.getProperties().put("com.sun.jersey.impl.client.httpclient.preemptiveBasicAuthentication", true);
            } else {
                throw new IllegalArgumentException(String.format("AuthenticationInfo of type %s is not supported!", connectionInfo.getAuthenticationInfo().getClass().getName()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void applyProxyIfAny(ConnectionInfo connectionInfo, ApacheHttpClient4Config config) {
        if (connectionInfo.getProxyInfos().size() <= 0) return;
        ProxyInfo proxyInfo = connectionInfo.getProxyInfos().get((Object)connectionInfo.getBaseUrl().getProtocol());
        if (proxyInfo == null) throw new IllegalArgumentException("ProxyInfo and BaseUrl protocols does not align!");
        config.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + proxyInfo.getProxyHost() + ":" + proxyInfo.getProxyPort());
        if (proxyInfo.getProxyAuthentication() == null) return;
        if (!(proxyInfo.getProxyAuthentication() instanceof UsernamePasswordAuthenticationInfo)) throw new IllegalArgumentException(String.format("AuthenticationInfo of type %s is not supported!", connectionInfo.getAuthenticationInfo().getClass().getName()));
        UsernamePasswordAuthenticationInfo upinfo = (UsernamePasswordAuthenticationInfo)proxyInfo.getProxyAuthentication();
        config.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", upinfo.getUsername());
        config.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", upinfo.getPassword());
    }
}

