/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest.jersey;

import com.google.common.base.Throwables;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.client.rest.jersey.ContextAwareUniformInterfaceException;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.client.rest.jersey.NexusClientHandlerException;
import org.sonatype.sisu.siesta.common.SiestaMediaType;
import org.sonatype.sisu.siesta.common.error.ErrorXO;
import org.sonatype.sisu.siesta.common.validation.ValidationErrorXO;
import org.sonatype.sisu.siesta.common.validation.ValidationErrorsException;

public class JerseyUtils {
    public static final MediaType CONTENT_TYPE = MediaType.APPLICATION_JSON_TYPE;
    public static final MediaType[] ACCEPTS = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, SiestaMediaType.VND_ERROR_V1_JSON_TYPE, SiestaMediaType.VND_VALIDATION_ERRORS_V1_JSON_TYPE};

    private JerseyUtils() {
    }

    public static boolean isError(ClientResponse response) {
        return SiestaMediaType.VND_ERROR_V1_JSON_TYPE.equals((Object)response.getType());
    }

    public static boolean isValidationError(ClientResponse response) {
        return SiestaMediaType.VND_VALIDATION_ERRORS_V1_JSON_TYPE.equals((Object)response.getType());
    }

    public static ClientResponse handle(JerseyNexusClient nexusClient, Callable<ClientResponse> callable) {
        try {
            ClientResponse response = callable.call();
            response.bufferEntity();
            if (JerseyUtils.isValidationError(response)) {
                throw new ValidationErrorsException().withErrors((List)response.getEntity((GenericType)new GenericType<List<ValidationErrorXO>>(){}));
            }
            if (JerseyUtils.isError(response)) {
                final ErrorXO error = (ErrorXO)response.getEntity(ErrorXO.class);
                throw nexusClient.convert(new ContextAwareUniformInterfaceException(response){

                    @Override
                    public String getMessage(int status) {
                        return error.getMessage() + " (" + error.getId() + ")";
                    }
                });
            }
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)response.getClientResponseStatus().getFamily())) {
                throw nexusClient.convert(new UniformInterfaceException(response));
            }
            response.close();
            return response;
        }
        catch (ClientHandlerException e) {
            throw new NexusClientHandlerException(e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> T handle(JerseyNexusClient nexusClient, Callable<ClientResponse> callable, Class<T> expectedEntityType) {
        return JerseyUtils.getEntity(nexusClient, JerseyUtils.handle(nexusClient, callable), expectedEntityType);
    }

    public static <T> T handle(JerseyNexusClient nexusClient, Callable<ClientResponse> callable, GenericType<T> expectedEntityType) {
        return JerseyUtils.getEntity(nexusClient, JerseyUtils.handle(nexusClient, callable), expectedEntityType);
    }

    public static <T> T getEntity(JerseyNexusClient nexusClient, ClientResponse response, Class<T> expectedEntityType) {
        try {
            return (T)response.getEntity(expectedEntityType);
        }
        catch (ClientHandlerException e) {
            throw nexusClient.convert(e);
        }
        catch (UniformInterfaceException e) {
            throw nexusClient.convert(e);
        }
    }

    public static <T> T getEntity(JerseyNexusClient nexusClient, ClientResponse response, GenericType<T> expectedEntityType) {
        try {
            return (T)response.getEntity(expectedEntityType);
        }
        catch (ClientHandlerException e) {
            throw nexusClient.convert(e);
        }
        catch (UniformInterfaceException e) {
            throw nexusClient.convert(e);
        }
    }
}

